/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.sch.model.TargetDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class FunctionsTargetDetails
extends TargetDetails {
    @JsonProperty(value="functionId")
    private final String functionId;
    @JsonProperty(value="batchSizeInKbs")
    private final Integer batchSizeInKbs;
    @JsonProperty(value="batchSizeInNum")
    private final Integer batchSizeInNum;
    @JsonProperty(value="batchTimeInSec")
    private final Integer batchTimeInSec;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FunctionsTargetDetails(String functionId, Integer batchSizeInKbs, Integer batchSizeInNum, Integer batchTimeInSec) {
        this.functionId = functionId;
        this.batchSizeInKbs = batchSizeInKbs;
        this.batchSizeInNum = batchSizeInNum;
        this.batchTimeInSec = batchTimeInSec;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public Integer getBatchSizeInKbs() {
        return this.batchSizeInKbs;
    }

    public Integer getBatchSizeInNum() {
        return this.batchSizeInNum;
    }

    public Integer getBatchTimeInSec() {
        return this.batchTimeInSec;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FunctionsTargetDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", functionId=").append(String.valueOf(this.functionId));
        sb.append(", batchSizeInKbs=").append(String.valueOf(this.batchSizeInKbs));
        sb.append(", batchSizeInNum=").append(String.valueOf(this.batchSizeInNum));
        sb.append(", batchTimeInSec=").append(String.valueOf(this.batchTimeInSec));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionsTargetDetails)) {
            return false;
        }
        FunctionsTargetDetails other = (FunctionsTargetDetails)((Object)o);
        return Objects.equals(this.functionId, other.functionId) && Objects.equals(this.batchSizeInKbs, other.batchSizeInKbs) && Objects.equals(this.batchSizeInNum, other.batchSizeInNum) && Objects.equals(this.batchTimeInSec, other.batchTimeInSec) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.functionId == null ? 43 : this.functionId.hashCode());
        result = result * 59 + (this.batchSizeInKbs == null ? 43 : this.batchSizeInKbs.hashCode());
        result = result * 59 + (this.batchSizeInNum == null ? 43 : this.batchSizeInNum.hashCode());
        result = result * 59 + (this.batchTimeInSec == null ? 43 : this.batchTimeInSec.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="functionId")
        private String functionId;
        @JsonProperty(value="batchSizeInKbs")
        private Integer batchSizeInKbs;
        @JsonProperty(value="batchSizeInNum")
        private Integer batchSizeInNum;
        @JsonProperty(value="batchTimeInSec")
        private Integer batchTimeInSec;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            this.__explicitlySet__.add("functionId");
            return this;
        }

        public Builder batchSizeInKbs(Integer batchSizeInKbs) {
            this.batchSizeInKbs = batchSizeInKbs;
            this.__explicitlySet__.add("batchSizeInKbs");
            return this;
        }

        public Builder batchSizeInNum(Integer batchSizeInNum) {
            this.batchSizeInNum = batchSizeInNum;
            this.__explicitlySet__.add("batchSizeInNum");
            return this;
        }

        public Builder batchTimeInSec(Integer batchTimeInSec) {
            this.batchTimeInSec = batchTimeInSec;
            this.__explicitlySet__.add("batchTimeInSec");
            return this;
        }

        public FunctionsTargetDetails build() {
            FunctionsTargetDetails model = new FunctionsTargetDetails(this.functionId, this.batchSizeInKbs, this.batchSizeInNum, this.batchTimeInSec);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FunctionsTargetDetails model) {
            if (model.wasPropertyExplicitlySet("functionId")) {
                this.functionId(model.getFunctionId());
            }
            if (model.wasPropertyExplicitlySet("batchSizeInKbs")) {
                this.batchSizeInKbs(model.getBatchSizeInKbs());
            }
            if (model.wasPropertyExplicitlySet("batchSizeInNum")) {
                this.batchSizeInNum(model.getBatchSizeInNum());
            }
            if (model.wasPropertyExplicitlySet("batchTimeInSec")) {
                this.batchTimeInSec(model.getBatchTimeInSec());
            }
            return this;
        }
    }
}

