/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.sch.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.sch.model.SourceDetails;
import com.oracle.bmc.sch.model.StreamingCursorDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class StreamingSourceDetails
extends SourceDetails {
    @JsonProperty(value="streamId")
    private final String streamId;
    @JsonProperty(value="cursor")
    private final StreamingCursorDetails cursor;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StreamingSourceDetails(String streamId, StreamingCursorDetails cursor) {
        this.streamId = streamId;
        this.cursor = cursor;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public StreamingCursorDetails getCursor() {
        return this.cursor;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StreamingSourceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", streamId=").append(String.valueOf(this.streamId));
        sb.append(", cursor=").append(String.valueOf((Object)this.cursor));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamingSourceDetails)) {
            return false;
        }
        StreamingSourceDetails other = (StreamingSourceDetails)((Object)o);
        return Objects.equals(this.streamId, other.streamId) && Objects.equals((Object)this.cursor, (Object)other.cursor) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.cursor == null ? 43 : this.cursor.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="streamId")
        private String streamId;
        @JsonProperty(value="cursor")
        private StreamingCursorDetails cursor;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            this.__explicitlySet__.add("streamId");
            return this;
        }

        public Builder cursor(StreamingCursorDetails cursor) {
            this.cursor = cursor;
            this.__explicitlySet__.add("cursor");
            return this;
        }

        public StreamingSourceDetails build() {
            StreamingSourceDetails model = new StreamingSourceDetails(this.streamId, this.cursor);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StreamingSourceDetails model) {
            if (model.wasPropertyExplicitlySet("streamId")) {
                this.streamId(model.getStreamId());
            }
            if (model.wasPropertyExplicitlySet("cursor")) {
                this.cursor(model.getCursor());
            }
            return this;
        }
    }
}

