/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.secrets.Secrets;
import com.oracle.bmc.secrets.SecretsPaginators;
import com.oracle.bmc.secrets.model.SecretBundle;
import com.oracle.bmc.secrets.model.SecretBundleVersionSummary;
import com.oracle.bmc.secrets.requests.GetSecretBundleByNameRequest;
import com.oracle.bmc.secrets.requests.GetSecretBundleRequest;
import com.oracle.bmc.secrets.requests.ListSecretBundleVersionsRequest;
import com.oracle.bmc.secrets.responses.GetSecretBundleByNameResponse;
import com.oracle.bmc.secrets.responses.GetSecretBundleResponse;
import com.oracle.bmc.secrets.responses.ListSecretBundleVersionsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretsClient
extends BaseSyncClient
implements Secrets {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SECRETS").serviceEndpointPrefix("").serviceEndpointTemplate("https://secrets.vaults.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SecretsClient.class);
    private final SecretsPaginators paginators = new SecretsPaginators(this);

    SecretsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetSecretBundleResponse getSecretBundle(GetSecretBundleRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (GetSecretBundleResponse)this.clientCall(request, GetSecretBundleResponse::builder).logger(LOG, "getSecretBundle").serviceDetails("Secrets", "GetSecretBundle", "https://docs.oracle.com/iaas/api/#/en/secretretrieval/20190301/SecretBundle/GetSecretBundle").method(Method.GET).requestBuilder(GetSecretBundleRequest::builder).basePath("/20190301").appendPathParam("secretbundles").appendPathParam(request.getSecretId()).appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("secretVersionName", (Object)request.getSecretVersionName()).appendEnumQueryParam("stage", (BmcEnum)request.getStage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecretBundle.class, GetSecretBundleResponse.Builder::secretBundle).handleResponseHeaderString("etag", GetSecretBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecretBundleResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetSecretBundleByNameResponse getSecretBundleByName(GetSecretBundleByNameRequest request) {
        Objects.requireNonNull(request.getSecretName(), "secretName is required");
        Objects.requireNonNull(request.getVaultId(), "vaultId is required");
        return (GetSecretBundleByNameResponse)this.clientCall(request, GetSecretBundleByNameResponse::builder).logger(LOG, "getSecretBundleByName").serviceDetails("Secrets", "GetSecretBundleByName", "https://docs.oracle.com/iaas/api/#/en/secretretrieval/20190301/SecretBundle/GetSecretBundleByName").method(Method.POST).requestBuilder(GetSecretBundleByNameRequest::builder).basePath("/20190301").appendPathParam("secretbundles").appendPathParam("actions").appendPathParam("getByName").appendQueryParam("secretName", (Object)request.getSecretName()).appendQueryParam("vaultId", (Object)request.getVaultId()).appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("secretVersionName", (Object)request.getSecretVersionName()).appendEnumQueryParam("stage", (BmcEnum)request.getStage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecretBundle.class, GetSecretBundleByNameResponse.Builder::secretBundle).handleResponseHeaderString("opc-request-id", GetSecretBundleByNameResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListSecretBundleVersionsResponse listSecretBundleVersions(ListSecretBundleVersionsRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (ListSecretBundleVersionsResponse)this.clientCall(request, ListSecretBundleVersionsResponse::builder).logger(LOG, "listSecretBundleVersions").serviceDetails("Secrets", "ListSecretBundleVersions", "https://docs.oracle.com/iaas/api/#/en/secretretrieval/20190301/SecretBundleVersionSummary/ListSecretBundleVersions").method(Method.GET).requestBuilder(ListSecretBundleVersionsRequest::builder).basePath("/20190301").appendPathParam("secretbundles").appendPathParam(request.getSecretId()).appendPathParam("versions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SecretBundleVersionSummary.class, ListSecretBundleVersionsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSecretBundleVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecretBundleVersionsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SecretsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SecretsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SecretsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SecretsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SecretsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SecretsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SecretsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SecretsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SecretsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SecretsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SecretsClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SecretsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SecretsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

