/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.secrets.model.SecretBundleContentDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecretBundle
extends ExplicitlySetBmcModel {
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="versionNumber")
    private final Long versionNumber;
    @JsonProperty(value="versionName")
    private final String versionName;
    @JsonProperty(value="secretBundleContent")
    private final SecretBundleContentDetails secretBundleContent;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="timeOfExpiry")
    private final Date timeOfExpiry;
    @JsonProperty(value="stages")
    private final List<Stages> stages;
    @JsonProperty(value="metadata")
    private final Map<String, Object> metadata;

    @Deprecated
    @ConstructorProperties(value={"secretId", "timeCreated", "versionNumber", "versionName", "secretBundleContent", "timeOfDeletion", "timeOfExpiry", "stages", "metadata"})
    public SecretBundle(String secretId, Date timeCreated, Long versionNumber, String versionName, SecretBundleContentDetails secretBundleContent, Date timeOfDeletion, Date timeOfExpiry, List<Stages> stages, Map<String, Object> metadata) {
        this.secretId = secretId;
        this.timeCreated = timeCreated;
        this.versionNumber = versionNumber;
        this.versionName = versionName;
        this.secretBundleContent = secretBundleContent;
        this.timeOfDeletion = timeOfDeletion;
        this.timeOfExpiry = timeOfExpiry;
        this.stages = stages;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSecretId() {
        return this.secretId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public SecretBundleContentDetails getSecretBundleContent() {
        return this.secretBundleContent;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public Date getTimeOfExpiry() {
        return this.timeOfExpiry;
    }

    public List<Stages> getStages() {
        return this.stages;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecretBundle(");
        sb.append("super=").append(super.toString());
        sb.append("secretId=").append(String.valueOf(this.secretId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(", versionName=").append(String.valueOf(this.versionName));
        sb.append(", secretBundleContent=").append(String.valueOf((Object)this.secretBundleContent));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", timeOfExpiry=").append(String.valueOf(this.timeOfExpiry));
        sb.append(", stages=").append(String.valueOf(this.stages));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretBundle)) {
            return false;
        }
        SecretBundle other = (SecretBundle)((Object)o);
        return Objects.equals(this.secretId, other.secretId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.versionName, other.versionName) && Objects.equals((Object)this.secretBundleContent, (Object)other.secretBundleContent) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals(this.timeOfExpiry, other.timeOfExpiry) && Objects.equals(this.stages, other.stages) && Objects.equals(this.metadata, other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.versionName == null ? 43 : this.versionName.hashCode());
        result = result * 59 + (this.secretBundleContent == null ? 43 : this.secretBundleContent.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.timeOfExpiry == null ? 43 : this.timeOfExpiry.hashCode());
        result = result * 59 + (this.stages == null ? 43 : this.stages.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Stages implements BmcEnum
    {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Stages> map;

        private Stages(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stages create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Stages', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Stages.class);
            map = new HashMap<String, Stages>();
            for (Stages v : Stages.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="versionNumber")
        private Long versionNumber;
        @JsonProperty(value="versionName")
        private String versionName;
        @JsonProperty(value="secretBundleContent")
        private SecretBundleContentDetails secretBundleContent;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="timeOfExpiry")
        private Date timeOfExpiry;
        @JsonProperty(value="stages")
        private List<Stages> stages;
        @JsonProperty(value="metadata")
        private Map<String, Object> metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            this.__explicitlySet__.add("versionName");
            return this;
        }

        public Builder secretBundleContent(SecretBundleContentDetails secretBundleContent) {
            this.secretBundleContent = secretBundleContent;
            this.__explicitlySet__.add("secretBundleContent");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder timeOfExpiry(Date timeOfExpiry) {
            this.timeOfExpiry = timeOfExpiry;
            this.__explicitlySet__.add("timeOfExpiry");
            return this;
        }

        public Builder stages(List<Stages> stages) {
            this.stages = stages;
            this.__explicitlySet__.add("stages");
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public SecretBundle build() {
            SecretBundle model = new SecretBundle(this.secretId, this.timeCreated, this.versionNumber, this.versionName, this.secretBundleContent, this.timeOfDeletion, this.timeOfExpiry, this.stages, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecretBundle model) {
            if (model.wasPropertyExplicitlySet("secretId")) {
                this.secretId(model.getSecretId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("versionNumber")) {
                this.versionNumber(model.getVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("versionName")) {
                this.versionName(model.getVersionName());
            }
            if (model.wasPropertyExplicitlySet("secretBundleContent")) {
                this.secretBundleContent(model.getSecretBundleContent());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("timeOfExpiry")) {
                this.timeOfExpiry(model.getTimeOfExpiry());
            }
            if (model.wasPropertyExplicitlySet("stages")) {
                this.stages(model.getStages());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

