/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.securityattribute.SecurityAttribute;
import com.oracle.bmc.securityattribute.SecurityAttributePaginators;
import com.oracle.bmc.securityattribute.SecurityAttributeWaiters;
import com.oracle.bmc.securityattribute.model.SecurityAttributeNamespace;
import com.oracle.bmc.securityattribute.model.SecurityAttributeNamespaceSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeWorkRequest;
import com.oracle.bmc.securityattribute.model.SecurityAttributeWorkRequestErrorSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeWorkRequestLogSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeWorkRequestSummary;
import com.oracle.bmc.securityattribute.requests.BulkDeleteSecurityAttributesRequest;
import com.oracle.bmc.securityattribute.requests.BulkEditSecurityAttributesRequest;
import com.oracle.bmc.securityattribute.requests.CascadingDeleteSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.ChangeSecurityAttributeNamespaceCompartmentRequest;
import com.oracle.bmc.securityattribute.requests.CreateSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.CreateSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.requests.DeleteSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.DeleteSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeWorkRequestRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeNamespacesRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestErrorsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestLogsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributesRequest;
import com.oracle.bmc.securityattribute.requests.UpdateSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.UpdateSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.responses.BulkDeleteSecurityAttributesResponse;
import com.oracle.bmc.securityattribute.responses.BulkEditSecurityAttributesResponse;
import com.oracle.bmc.securityattribute.responses.CascadingDeleteSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.ChangeSecurityAttributeNamespaceCompartmentResponse;
import com.oracle.bmc.securityattribute.responses.CreateSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.CreateSecurityAttributeResponse;
import com.oracle.bmc.securityattribute.responses.DeleteSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.DeleteSecurityAttributeResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeWorkRequestResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeNamespacesResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestErrorsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestLogsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributesResponse;
import com.oracle.bmc.securityattribute.responses.UpdateSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.UpdateSecurityAttributeResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAttributeClient
extends BaseSyncClient
implements SecurityAttribute {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SECURITYATTRIBUTE").serviceEndpointPrefix("").serviceEndpointTemplate("https://security-attribute.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SecurityAttributeClient.class);
    private final SecurityAttributeWaiters waiters;
    private final SecurityAttributePaginators paginators;

    SecurityAttributeClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("SecurityAttribute-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new SecurityAttributeWaiters(executorService, this);
        this.paginators = new SecurityAttributePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public BulkDeleteSecurityAttributesResponse bulkDeleteSecurityAttributes(BulkDeleteSecurityAttributesRequest request) {
        Objects.requireNonNull(request.getBulkDeleteSecurityAttributesDetails(), "bulkDeleteSecurityAttributesDetails is required");
        return (BulkDeleteSecurityAttributesResponse)this.clientCall(request, BulkDeleteSecurityAttributesResponse::builder).logger(LOG, "bulkDeleteSecurityAttributes").serviceDetails("SecurityAttribute", "BulkDeleteSecurityAttributes", "").method(Method.POST).requestBuilder(BulkDeleteSecurityAttributesRequest::builder).basePath("/20240815").appendPathParam("securityAttributes").appendPathParam("actions").appendPathParam("bulkDelete").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", BulkDeleteSecurityAttributesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BulkDeleteSecurityAttributesResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public BulkEditSecurityAttributesResponse bulkEditSecurityAttributes(BulkEditSecurityAttributesRequest request) {
        return (BulkEditSecurityAttributesResponse)this.clientCall(request, BulkEditSecurityAttributesResponse::builder).logger(LOG, "bulkEditSecurityAttributes").serviceDetails("SecurityAttribute", "BulkEditSecurityAttributes", "").method(Method.POST).requestBuilder(BulkEditSecurityAttributesRequest::builder).basePath("/20240815").appendPathParam("securityAttributes").appendPathParam("actions").appendPathParam("bulkEdit").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", BulkEditSecurityAttributesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BulkEditSecurityAttributesResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CascadingDeleteSecurityAttributeNamespaceResponse cascadingDeleteSecurityAttributeNamespace(CascadingDeleteSecurityAttributeNamespaceRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        return (CascadingDeleteSecurityAttributeNamespaceResponse)this.clientCall(request, CascadingDeleteSecurityAttributeNamespaceResponse::builder).logger(LOG, "cascadingDeleteSecurityAttributeNamespace").serviceDetails("SecurityAttribute", "CascadingDeleteSecurityAttributeNamespace", "").method(Method.POST).requestBuilder(CascadingDeleteSecurityAttributeNamespaceRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).appendPathParam("actions").appendPathParam("cascadeDelete").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CascadingDeleteSecurityAttributeNamespaceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CascadingDeleteSecurityAttributeNamespaceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeSecurityAttributeNamespaceCompartmentResponse changeSecurityAttributeNamespaceCompartment(ChangeSecurityAttributeNamespaceCompartmentRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSecurityAttributeNamespaceCompartmentDetails(), "changeSecurityAttributeNamespaceCompartmentDetails is required");
        return (ChangeSecurityAttributeNamespaceCompartmentResponse)this.clientCall(request, ChangeSecurityAttributeNamespaceCompartmentResponse::builder).logger(LOG, "changeSecurityAttributeNamespaceCompartment").serviceDetails("SecurityAttribute", "ChangeSecurityAttributeNamespaceCompartment", "").method(Method.POST).requestBuilder(ChangeSecurityAttributeNamespaceCompartmentRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeSecurityAttributeNamespaceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSecurityAttributeResponse createSecurityAttribute(CreateSecurityAttributeRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateSecurityAttributeDetails(), "createSecurityAttributeDetails is required");
        return (CreateSecurityAttributeResponse)this.clientCall(request, CreateSecurityAttributeResponse::builder).logger(LOG, "createSecurityAttribute").serviceDetails("SecurityAttribute", "CreateSecurityAttribute", "").method(Method.POST).requestBuilder(CreateSecurityAttributeRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).appendPathParam("securityAttributes").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.securityattribute.model.SecurityAttribute.class, CreateSecurityAttributeResponse.Builder::securityAttribute).handleResponseHeaderString("opc-request-id", CreateSecurityAttributeResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSecurityAttributeResponse.Builder::etag).callSync();
    }

    @Override
    public CreateSecurityAttributeNamespaceResponse createSecurityAttributeNamespace(CreateSecurityAttributeNamespaceRequest request) {
        Objects.requireNonNull(request.getCreateSecurityAttributeNamespaceDetails(), "createSecurityAttributeNamespaceDetails is required");
        return (CreateSecurityAttributeNamespaceResponse)this.clientCall(request, CreateSecurityAttributeNamespaceResponse::builder).logger(LOG, "createSecurityAttributeNamespace").serviceDetails("SecurityAttribute", "CreateSecurityAttributeNamespace", "").method(Method.POST).requestBuilder(CreateSecurityAttributeNamespaceRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(SecurityAttributeNamespace.class, CreateSecurityAttributeNamespaceResponse.Builder::securityAttributeNamespace).handleResponseHeaderString("opc-request-id", CreateSecurityAttributeNamespaceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSecurityAttributeNamespaceResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteSecurityAttributeResponse deleteSecurityAttribute(DeleteSecurityAttributeRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSecurityAttributeName(), (String)"securityAttributeName must not be blank", (Object[])new Object[0]);
        return (DeleteSecurityAttributeResponse)this.clientCall(request, DeleteSecurityAttributeResponse::builder).logger(LOG, "deleteSecurityAttribute").serviceDetails("SecurityAttribute", "DeleteSecurityAttribute", "").method(Method.DELETE).requestBuilder(DeleteSecurityAttributeRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).appendPathParam("securityAttributes").appendPathParam(request.getSecurityAttributeName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteSecurityAttributeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteSecurityAttributeResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteSecurityAttributeNamespaceResponse deleteSecurityAttributeNamespace(DeleteSecurityAttributeNamespaceRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        return (DeleteSecurityAttributeNamespaceResponse)this.clientCall(request, DeleteSecurityAttributeNamespaceResponse::builder).logger(LOG, "deleteSecurityAttributeNamespace").serviceDetails("SecurityAttribute", "DeleteSecurityAttributeNamespace", "").method(Method.DELETE).requestBuilder(DeleteSecurityAttributeNamespaceRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteSecurityAttributeNamespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSecurityAttributeResponse getSecurityAttribute(GetSecurityAttributeRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSecurityAttributeName(), (String)"securityAttributeName must not be blank", (Object[])new Object[0]);
        return (GetSecurityAttributeResponse)this.clientCall(request, GetSecurityAttributeResponse::builder).logger(LOG, "getSecurityAttribute").serviceDetails("SecurityAttribute", "GetSecurityAttribute", "").method(Method.GET).requestBuilder(GetSecurityAttributeRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).appendPathParam("securityAttributes").appendPathParam(request.getSecurityAttributeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.securityattribute.model.SecurityAttribute.class, GetSecurityAttributeResponse.Builder::securityAttribute).handleResponseHeaderString("opc-request-id", GetSecurityAttributeResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSecurityAttributeResponse.Builder::etag).callSync();
    }

    @Override
    public GetSecurityAttributeNamespaceResponse getSecurityAttributeNamespace(GetSecurityAttributeNamespaceRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        return (GetSecurityAttributeNamespaceResponse)this.clientCall(request, GetSecurityAttributeNamespaceResponse::builder).logger(LOG, "getSecurityAttributeNamespace").serviceDetails("SecurityAttribute", "GetSecurityAttributeNamespace", "").method(Method.GET).requestBuilder(GetSecurityAttributeNamespaceRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SecurityAttributeNamespace.class, GetSecurityAttributeNamespaceResponse.Builder::securityAttributeNamespace).handleResponseHeaderString("opc-request-id", GetSecurityAttributeNamespaceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSecurityAttributeNamespaceResponse.Builder::etag).callSync();
    }

    @Override
    public GetSecurityAttributeWorkRequestResponse getSecurityAttributeWorkRequest(GetSecurityAttributeWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetSecurityAttributeWorkRequestResponse)this.clientCall(request, GetSecurityAttributeWorkRequestResponse::builder).logger(LOG, "getSecurityAttributeWorkRequest").serviceDetails("SecurityAttribute", "GetSecurityAttributeWorkRequest", "").method(Method.GET).requestBuilder(GetSecurityAttributeWorkRequestRequest::builder).basePath("/20240815").appendPathParam("securityAttributeWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SecurityAttributeWorkRequest.class, GetSecurityAttributeWorkRequestResponse.Builder::securityAttributeWorkRequest).handleResponseHeaderString("opc-request-id", GetSecurityAttributeWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetSecurityAttributeWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListSecurityAttributeNamespacesResponse listSecurityAttributeNamespaces(ListSecurityAttributeNamespacesRequest request) {
        return (ListSecurityAttributeNamespacesResponse)this.clientCall(request, ListSecurityAttributeNamespacesResponse::builder).logger(LOG, "listSecurityAttributeNamespaces").serviceDetails("SecurityAttribute", "ListSecurityAttributeNamespaces", "").method(Method.GET).requestBuilder(ListSecurityAttributeNamespacesRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(SecurityAttributeNamespaceSummary.class, ListSecurityAttributeNamespacesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSecurityAttributeNamespacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecurityAttributeNamespacesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSecurityAttributeWorkRequestErrorsResponse listSecurityAttributeWorkRequestErrors(ListSecurityAttributeWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListSecurityAttributeWorkRequestErrorsResponse)this.clientCall(request, ListSecurityAttributeWorkRequestErrorsResponse::builder).logger(LOG, "listSecurityAttributeWorkRequestErrors").serviceDetails("SecurityAttribute", "ListSecurityAttributeWorkRequestErrors", "").method(Method.GET).requestBuilder(ListSecurityAttributeWorkRequestErrorsRequest::builder).basePath("/20240815").appendPathParam("securityAttributeWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(SecurityAttributeWorkRequestErrorSummary.class, ListSecurityAttributeWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSecurityAttributeWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", ListSecurityAttributeWorkRequestErrorsResponse.Builder::retryAfter).handleResponseHeaderString("opc-next-page", ListSecurityAttributeWorkRequestErrorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSecurityAttributeWorkRequestLogsResponse listSecurityAttributeWorkRequestLogs(ListSecurityAttributeWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListSecurityAttributeWorkRequestLogsResponse)this.clientCall(request, ListSecurityAttributeWorkRequestLogsResponse::builder).logger(LOG, "listSecurityAttributeWorkRequestLogs").serviceDetails("SecurityAttribute", "ListSecurityAttributeWorkRequestLogs", "").method(Method.GET).requestBuilder(ListSecurityAttributeWorkRequestLogsRequest::builder).basePath("/20240815").appendPathParam("securityAttributeWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(SecurityAttributeWorkRequestLogSummary.class, ListSecurityAttributeWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSecurityAttributeWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", ListSecurityAttributeWorkRequestLogsResponse.Builder::retryAfter).handleResponseHeaderString("opc-next-page", ListSecurityAttributeWorkRequestLogsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSecurityAttributeWorkRequestsResponse listSecurityAttributeWorkRequests(ListSecurityAttributeWorkRequestsRequest request) {
        return (ListSecurityAttributeWorkRequestsResponse)this.clientCall(request, ListSecurityAttributeWorkRequestsResponse::builder).logger(LOG, "listSecurityAttributeWorkRequests").serviceDetails("SecurityAttribute", "ListSecurityAttributeWorkRequests", "").method(Method.GET).requestBuilder(ListSecurityAttributeWorkRequestsRequest::builder).basePath("/20240815").appendPathParam("securityAttributeWorkRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("resourceIdentifier", (Object)request.getResourceIdentifier()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(SecurityAttributeWorkRequestSummary.class, ListSecurityAttributeWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSecurityAttributeWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecurityAttributeWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSecurityAttributesResponse listSecurityAttributes(ListSecurityAttributesRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        return (ListSecurityAttributesResponse)this.clientCall(request, ListSecurityAttributesResponse::builder).logger(LOG, "listSecurityAttributes").serviceDetails("SecurityAttribute", "ListSecurityAttributes", "").method(Method.GET).requestBuilder(ListSecurityAttributesRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).appendPathParam("securityAttributes").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(SecurityAttributeSummary.class, ListSecurityAttributesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListSecurityAttributesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSecurityAttributesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateSecurityAttributeResponse updateSecurityAttribute(UpdateSecurityAttributeRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSecurityAttributeName(), (String)"securityAttributeName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSecurityAttributeDetails(), "updateSecurityAttributeDetails is required");
        return (UpdateSecurityAttributeResponse)this.clientCall(request, UpdateSecurityAttributeResponse::builder).logger(LOG, "updateSecurityAttribute").serviceDetails("SecurityAttribute", "UpdateSecurityAttribute", "").method(Method.PUT).requestBuilder(UpdateSecurityAttributeRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).appendPathParam("securityAttributes").appendPathParam(request.getSecurityAttributeName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.securityattribute.model.SecurityAttribute.class, UpdateSecurityAttributeResponse.Builder::securityAttribute).handleResponseHeaderString("opc-request-id", UpdateSecurityAttributeResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateSecurityAttributeResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateSecurityAttributeNamespaceResponse updateSecurityAttributeNamespace(UpdateSecurityAttributeNamespaceRequest request) {
        Validate.notBlank((String)request.getSecurityAttributeNamespaceId(), (String)"securityAttributeNamespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSecurityAttributeNamespaceDetails(), "updateSecurityAttributeNamespaceDetails is required");
        return (UpdateSecurityAttributeNamespaceResponse)this.clientCall(request, UpdateSecurityAttributeNamespaceResponse::builder).logger(LOG, "updateSecurityAttributeNamespace").serviceDetails("SecurityAttribute", "UpdateSecurityAttributeNamespace", "").method(Method.PUT).requestBuilder(UpdateSecurityAttributeNamespaceRequest::builder).basePath("/20240815").appendPathParam("securityAttributeNamespaces").appendPathParam(request.getSecurityAttributeNamespaceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(SecurityAttributeNamespace.class, UpdateSecurityAttributeNamespaceResponse.Builder::securityAttributeNamespace).handleResponseHeaderString("opc-request-id", UpdateSecurityAttributeNamespaceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateSecurityAttributeNamespaceResponse.Builder::etag).callSync();
    }

    @Override
    public SecurityAttributeWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public SecurityAttributePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SecurityAttributeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SecurityAttributeClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SecurityAttributeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SecurityAttributeClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SecurityAttributeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SecurityAttributeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SecurityAttributeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SecurityAttributeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SecurityAttributeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SecurityAttributeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SecurityAttributeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SecurityAttributeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SecurityAttributeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SecurityAttributeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SecurityAttributeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SecurityAttributeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SecurityAttributeClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "securityattribute";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"securityattribute");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public SecurityAttributeClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SecurityAttributeClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

