/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.securityattribute.SecurityAttribute;
import com.oracle.bmc.securityattribute.model.SecurityAttributeNamespaceSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeWorkRequestErrorSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeWorkRequestLogSummary;
import com.oracle.bmc.securityattribute.model.SecurityAttributeWorkRequestSummary;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeNamespacesRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestErrorsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestLogsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributeWorkRequestsRequest;
import com.oracle.bmc.securityattribute.requests.ListSecurityAttributesRequest;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeNamespacesResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestErrorsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestLogsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributeWorkRequestsResponse;
import com.oracle.bmc.securityattribute.responses.ListSecurityAttributesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SecurityAttributePaginators {
    private final SecurityAttribute client;

    public SecurityAttributePaginators(SecurityAttribute client) {
        this.client = client;
    }

    public Iterable<ListSecurityAttributeNamespacesResponse> listSecurityAttributeNamespacesResponseIterator(final ListSecurityAttributeNamespacesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecurityAttributeNamespacesRequest.Builder>(){

            @Override
            public ListSecurityAttributeNamespacesRequest.Builder get() {
                return ListSecurityAttributeNamespacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeNamespacesResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeNamespacesRequest.Builder>, ListSecurityAttributeNamespacesRequest>(){

            @Override
            public ListSecurityAttributeNamespacesRequest apply(RequestBuilderAndToken<ListSecurityAttributeNamespacesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeNamespacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeNamespacesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeNamespacesRequest, ListSecurityAttributeNamespacesResponse>(){

            @Override
            public ListSecurityAttributeNamespacesResponse apply(ListSecurityAttributeNamespacesRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeNamespaces(request);
            }
        });
    }

    public Iterable<SecurityAttributeNamespaceSummary> listSecurityAttributeNamespacesRecordIterator(final ListSecurityAttributeNamespacesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecurityAttributeNamespacesRequest.Builder>(){

            @Override
            public ListSecurityAttributeNamespacesRequest.Builder get() {
                return ListSecurityAttributeNamespacesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeNamespacesResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeNamespacesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeNamespacesRequest.Builder>, ListSecurityAttributeNamespacesRequest>(){

            @Override
            public ListSecurityAttributeNamespacesRequest apply(RequestBuilderAndToken<ListSecurityAttributeNamespacesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeNamespacesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeNamespacesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeNamespacesRequest, ListSecurityAttributeNamespacesResponse>(){

            @Override
            public ListSecurityAttributeNamespacesResponse apply(ListSecurityAttributeNamespacesRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeNamespaces(request);
            }
        }, (Function)new Function<ListSecurityAttributeNamespacesResponse, List<SecurityAttributeNamespaceSummary>>(){

            @Override
            public List<SecurityAttributeNamespaceSummary> apply(ListSecurityAttributeNamespacesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSecurityAttributeWorkRequestErrorsResponse> listSecurityAttributeWorkRequestErrorsResponseIterator(final ListSecurityAttributeWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecurityAttributeWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListSecurityAttributeWorkRequestErrorsRequest.Builder get() {
                return ListSecurityAttributeWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeWorkRequestErrorsRequest.Builder>, ListSecurityAttributeWorkRequestErrorsRequest>(){

            @Override
            public ListSecurityAttributeWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListSecurityAttributeWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestErrorsRequest, ListSecurityAttributeWorkRequestErrorsResponse>(){

            @Override
            public ListSecurityAttributeWorkRequestErrorsResponse apply(ListSecurityAttributeWorkRequestErrorsRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeWorkRequestErrors(request);
            }
        });
    }

    public Iterable<SecurityAttributeWorkRequestErrorSummary> listSecurityAttributeWorkRequestErrorsRecordIterator(final ListSecurityAttributeWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecurityAttributeWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListSecurityAttributeWorkRequestErrorsRequest.Builder get() {
                return ListSecurityAttributeWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeWorkRequestErrorsRequest.Builder>, ListSecurityAttributeWorkRequestErrorsRequest>(){

            @Override
            public ListSecurityAttributeWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListSecurityAttributeWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestErrorsRequest, ListSecurityAttributeWorkRequestErrorsResponse>(){

            @Override
            public ListSecurityAttributeWorkRequestErrorsResponse apply(ListSecurityAttributeWorkRequestErrorsRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeWorkRequestErrors(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestErrorsResponse, List<SecurityAttributeWorkRequestErrorSummary>>(){

            @Override
            public List<SecurityAttributeWorkRequestErrorSummary> apply(ListSecurityAttributeWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSecurityAttributeWorkRequestLogsResponse> listSecurityAttributeWorkRequestLogsResponseIterator(final ListSecurityAttributeWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecurityAttributeWorkRequestLogsRequest.Builder>(){

            @Override
            public ListSecurityAttributeWorkRequestLogsRequest.Builder get() {
                return ListSecurityAttributeWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeWorkRequestLogsRequest.Builder>, ListSecurityAttributeWorkRequestLogsRequest>(){

            @Override
            public ListSecurityAttributeWorkRequestLogsRequest apply(RequestBuilderAndToken<ListSecurityAttributeWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestLogsRequest, ListSecurityAttributeWorkRequestLogsResponse>(){

            @Override
            public ListSecurityAttributeWorkRequestLogsResponse apply(ListSecurityAttributeWorkRequestLogsRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeWorkRequestLogs(request);
            }
        });
    }

    public Iterable<SecurityAttributeWorkRequestLogSummary> listSecurityAttributeWorkRequestLogsRecordIterator(final ListSecurityAttributeWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecurityAttributeWorkRequestLogsRequest.Builder>(){

            @Override
            public ListSecurityAttributeWorkRequestLogsRequest.Builder get() {
                return ListSecurityAttributeWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeWorkRequestLogsRequest.Builder>, ListSecurityAttributeWorkRequestLogsRequest>(){

            @Override
            public ListSecurityAttributeWorkRequestLogsRequest apply(RequestBuilderAndToken<ListSecurityAttributeWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestLogsRequest, ListSecurityAttributeWorkRequestLogsResponse>(){

            @Override
            public ListSecurityAttributeWorkRequestLogsResponse apply(ListSecurityAttributeWorkRequestLogsRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeWorkRequestLogs(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestLogsResponse, List<SecurityAttributeWorkRequestLogSummary>>(){

            @Override
            public List<SecurityAttributeWorkRequestLogSummary> apply(ListSecurityAttributeWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSecurityAttributeWorkRequestsResponse> listSecurityAttributeWorkRequestsResponseIterator(final ListSecurityAttributeWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecurityAttributeWorkRequestsRequest.Builder>(){

            @Override
            public ListSecurityAttributeWorkRequestsRequest.Builder get() {
                return ListSecurityAttributeWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestsResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeWorkRequestsRequest.Builder>, ListSecurityAttributeWorkRequestsRequest>(){

            @Override
            public ListSecurityAttributeWorkRequestsRequest apply(RequestBuilderAndToken<ListSecurityAttributeWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestsRequest, ListSecurityAttributeWorkRequestsResponse>(){

            @Override
            public ListSecurityAttributeWorkRequestsResponse apply(ListSecurityAttributeWorkRequestsRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeWorkRequests(request);
            }
        });
    }

    public Iterable<SecurityAttributeWorkRequestSummary> listSecurityAttributeWorkRequestsRecordIterator(final ListSecurityAttributeWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecurityAttributeWorkRequestsRequest.Builder>(){

            @Override
            public ListSecurityAttributeWorkRequestsRequest.Builder get() {
                return ListSecurityAttributeWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestsResponse, String>(){

            @Override
            public String apply(ListSecurityAttributeWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributeWorkRequestsRequest.Builder>, ListSecurityAttributeWorkRequestsRequest>(){

            @Override
            public ListSecurityAttributeWorkRequestsRequest apply(RequestBuilderAndToken<ListSecurityAttributeWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributeWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributeWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestsRequest, ListSecurityAttributeWorkRequestsResponse>(){

            @Override
            public ListSecurityAttributeWorkRequestsResponse apply(ListSecurityAttributeWorkRequestsRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributeWorkRequests(request);
            }
        }, (Function)new Function<ListSecurityAttributeWorkRequestsResponse, List<SecurityAttributeWorkRequestSummary>>(){

            @Override
            public List<SecurityAttributeWorkRequestSummary> apply(ListSecurityAttributeWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSecurityAttributesResponse> listSecurityAttributesResponseIterator(final ListSecurityAttributesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecurityAttributesRequest.Builder>(){

            @Override
            public ListSecurityAttributesRequest.Builder get() {
                return ListSecurityAttributesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributesResponse, String>(){

            @Override
            public String apply(ListSecurityAttributesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributesRequest.Builder>, ListSecurityAttributesRequest>(){

            @Override
            public ListSecurityAttributesRequest apply(RequestBuilderAndToken<ListSecurityAttributesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributesRequest, ListSecurityAttributesResponse>(){

            @Override
            public ListSecurityAttributesResponse apply(ListSecurityAttributesRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributes(request);
            }
        });
    }

    public Iterable<SecurityAttributeSummary> listSecurityAttributesRecordIterator(final ListSecurityAttributesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecurityAttributesRequest.Builder>(){

            @Override
            public ListSecurityAttributesRequest.Builder get() {
                return ListSecurityAttributesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecurityAttributesResponse, String>(){

            @Override
            public String apply(ListSecurityAttributesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecurityAttributesRequest.Builder>, ListSecurityAttributesRequest>(){

            @Override
            public ListSecurityAttributesRequest apply(RequestBuilderAndToken<ListSecurityAttributesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecurityAttributesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecurityAttributesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecurityAttributesRequest, ListSecurityAttributesResponse>(){

            @Override
            public ListSecurityAttributesResponse apply(ListSecurityAttributesRequest request) {
                return SecurityAttributePaginators.this.client.listSecurityAttributes(request);
            }
        }, (Function)new Function<ListSecurityAttributesResponse, List<SecurityAttributeSummary>>(){

            @Override
            public List<SecurityAttributeSummary> apply(ListSecurityAttributesResponse response) {
                return response.getItems();
            }
        });
    }
}

