/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute;

import com.oracle.bmc.securityattribute.SecurityAttribute;
import com.oracle.bmc.securityattribute.model.SecurityAttribute;
import com.oracle.bmc.securityattribute.model.SecurityAttributeNamespace;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeNamespaceRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeRequest;
import com.oracle.bmc.securityattribute.requests.GetSecurityAttributeWorkRequestRequest;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeNamespaceResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeResponse;
import com.oracle.bmc.securityattribute.responses.GetSecurityAttributeWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class SecurityAttributeWaiters {
    private final ExecutorService executorService;
    private final SecurityAttribute client;

    public SecurityAttributeWaiters(ExecutorService executorService, SecurityAttribute client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetSecurityAttributeRequest, GetSecurityAttributeResponse> forSecurityAttribute(GetSecurityAttributeRequest request, SecurityAttribute.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityAttribute(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityAttributeRequest, GetSecurityAttributeResponse> forSecurityAttribute(GetSecurityAttributeRequest request, SecurityAttribute.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityAttribute(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityAttributeRequest, GetSecurityAttributeResponse> forSecurityAttribute(GetSecurityAttributeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityAttribute.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSecurityAttribute(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityAttributeRequest, GetSecurityAttributeResponse> forSecurityAttribute(BmcGenericWaiter waiter, GetSecurityAttributeRequest request, SecurityAttribute.LifecycleState ... targetStates) {
        final HashSet<SecurityAttribute.LifecycleState> targetStatesSet = new HashSet<SecurityAttribute.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityAttributeRequest, GetSecurityAttributeResponse>(){

            @Override
            public GetSecurityAttributeResponse apply(GetSecurityAttributeRequest request) {
                return SecurityAttributeWaiters.this.client.getSecurityAttribute(request);
            }
        }, (Predicate)new Predicate<GetSecurityAttributeResponse>(){

            @Override
            public boolean test(GetSecurityAttributeResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityAttribute().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityAttribute.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityAttributeNamespaceRequest, GetSecurityAttributeNamespaceResponse> forSecurityAttributeNamespace(GetSecurityAttributeNamespaceRequest request, SecurityAttributeNamespace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityAttributeNamespace(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityAttributeNamespaceRequest, GetSecurityAttributeNamespaceResponse> forSecurityAttributeNamespace(GetSecurityAttributeNamespaceRequest request, SecurityAttributeNamespace.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityAttributeNamespace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityAttributeNamespaceRequest, GetSecurityAttributeNamespaceResponse> forSecurityAttributeNamespace(GetSecurityAttributeNamespaceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityAttributeNamespace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSecurityAttributeNamespace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityAttributeNamespaceRequest, GetSecurityAttributeNamespaceResponse> forSecurityAttributeNamespace(BmcGenericWaiter waiter, GetSecurityAttributeNamespaceRequest request, SecurityAttributeNamespace.LifecycleState ... targetStates) {
        final HashSet<SecurityAttributeNamespace.LifecycleState> targetStatesSet = new HashSet<SecurityAttributeNamespace.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityAttributeNamespaceRequest, GetSecurityAttributeNamespaceResponse>(){

            @Override
            public GetSecurityAttributeNamespaceResponse apply(GetSecurityAttributeNamespaceRequest request) {
                return SecurityAttributeWaiters.this.client.getSecurityAttributeNamespace(request);
            }
        }, (Predicate)new Predicate<GetSecurityAttributeNamespaceResponse>(){

            @Override
            public boolean test(GetSecurityAttributeNamespaceResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityAttributeNamespace().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityAttributeNamespace.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSecurityAttributeWorkRequestRequest, GetSecurityAttributeWorkRequestResponse> forSecurityAttributeWorkRequest(GetSecurityAttributeWorkRequestRequest request) {
        return this.forSecurityAttributeWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetSecurityAttributeWorkRequestRequest, GetSecurityAttributeWorkRequestResponse> forSecurityAttributeWorkRequest(GetSecurityAttributeWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forSecurityAttributeWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetSecurityAttributeWorkRequestRequest, GetSecurityAttributeWorkRequestResponse> forSecurityAttributeWorkRequest(BmcGenericWaiter waiter, GetSecurityAttributeWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityAttributeWorkRequestRequest, GetSecurityAttributeWorkRequestResponse>(){

            @Override
            public GetSecurityAttributeWorkRequestResponse apply(GetSecurityAttributeWorkRequestRequest request) {
                return SecurityAttributeWaiters.this.client.getSecurityAttributeWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetSecurityAttributeWorkRequestResponse>(){

            @Override
            public boolean test(GetSecurityAttributeWorkRequestResponse response) {
                return response.getSecurityAttributeWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

