/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BulkEditSecurityAttributeOperationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="securityAttributes")
    private final Map<String, Map<String, Object>> securityAttributes;

    @Deprecated
    @ConstructorProperties(value={"operationType", "securityAttributes"})
    public BulkEditSecurityAttributeOperationDetails(OperationType operationType, Map<String, Map<String, Object>> securityAttributes) {
        this.operationType = operationType;
        this.securityAttributes = securityAttributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Map<String, Map<String, Object>> getSecurityAttributes() {
        return this.securityAttributes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkEditSecurityAttributeOperationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", securityAttributes=").append(String.valueOf(this.securityAttributes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkEditSecurityAttributeOperationDetails)) {
            return false;
        }
        BulkEditSecurityAttributeOperationDetails other = (BulkEditSecurityAttributeOperationDetails)((Object)o);
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.securityAttributes, other.securityAttributes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.securityAttributes == null ? 43 : this.securityAttributes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationType implements BmcEnum
    {
        AddWhereAbsent("ADD_WHERE_ABSENT"),
        SetWherePresent("SET_WHERE_PRESENT"),
        AddOrSet("ADD_OR_SET"),
        Remove("REMOVE");

        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid OperationType: " + key);
        }

        static {
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="securityAttributes")
        private Map<String, Map<String, Object>> securityAttributes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder securityAttributes(Map<String, Map<String, Object>> securityAttributes) {
            this.securityAttributes = securityAttributes;
            this.__explicitlySet__.add("securityAttributes");
            return this;
        }

        public BulkEditSecurityAttributeOperationDetails build() {
            BulkEditSecurityAttributeOperationDetails model = new BulkEditSecurityAttributeOperationDetails(this.operationType, this.securityAttributes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BulkEditSecurityAttributeOperationDetails model) {
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("securityAttributes")) {
                this.securityAttributes(model.getSecurityAttributes());
            }
            return this;
        }
    }
}

