/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.securityattribute.model.BulkEditSecurityAttributeDetails;
import java.util.Objects;

public class BulkEditSecurityAttributesRequest
extends BmcRequest<BulkEditSecurityAttributeDetails> {
    private String opcRequestId;
    private String opcRetryToken;
    private BulkEditSecurityAttributeDetails bulkEditSecurityAttributeDetails;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public BulkEditSecurityAttributeDetails getBulkEditSecurityAttributeDetails() {
        return this.bulkEditSecurityAttributeDetails;
    }

    @InternalSdk
    public BulkEditSecurityAttributeDetails getBody$() {
        return this.bulkEditSecurityAttributeDetails;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).bulkEditSecurityAttributeDetails(this.bulkEditSecurityAttributeDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",bulkEditSecurityAttributeDetails=").append(String.valueOf((Object)this.bulkEditSecurityAttributeDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkEditSecurityAttributesRequest)) {
            return false;
        }
        BulkEditSecurityAttributesRequest other = (BulkEditSecurityAttributesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.bulkEditSecurityAttributeDetails, (Object)other.bulkEditSecurityAttributeDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.bulkEditSecurityAttributeDetails == null ? 43 : this.bulkEditSecurityAttributeDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkEditSecurityAttributesRequest, BulkEditSecurityAttributeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private BulkEditSecurityAttributeDetails bulkEditSecurityAttributeDetails = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder bulkEditSecurityAttributeDetails(BulkEditSecurityAttributeDetails bulkEditSecurityAttributeDetails) {
            this.bulkEditSecurityAttributeDetails = bulkEditSecurityAttributeDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkEditSecurityAttributesRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.bulkEditSecurityAttributeDetails(o.getBulkEditSecurityAttributeDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkEditSecurityAttributesRequest build() {
            BulkEditSecurityAttributesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkEditSecurityAttributeDetails body) {
            this.bulkEditSecurityAttributeDetails(body);
            return this;
        }

        public BulkEditSecurityAttributesRequest buildWithoutInvocationCallback() {
            BulkEditSecurityAttributesRequest request = new BulkEditSecurityAttributesRequest();
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.bulkEditSecurityAttributeDetails = this.bulkEditSecurityAttributeDetails;
            return request;
        }
    }
}

