/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.securityattribute.model.CreateSecurityAttributeDetails;
import java.util.Objects;

public class CreateSecurityAttributeRequest
extends BmcRequest<CreateSecurityAttributeDetails> {
    private String securityAttributeNamespaceId;
    private CreateSecurityAttributeDetails createSecurityAttributeDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getSecurityAttributeNamespaceId() {
        return this.securityAttributeNamespaceId;
    }

    public CreateSecurityAttributeDetails getCreateSecurityAttributeDetails() {
        return this.createSecurityAttributeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateSecurityAttributeDetails getBody$() {
        return this.createSecurityAttributeDetails;
    }

    public Builder toBuilder() {
        return new Builder().securityAttributeNamespaceId(this.securityAttributeNamespaceId).createSecurityAttributeDetails(this.createSecurityAttributeDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAttributeNamespaceId=").append(String.valueOf(this.securityAttributeNamespaceId));
        sb.append(",createSecurityAttributeDetails=").append(String.valueOf((Object)this.createSecurityAttributeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSecurityAttributeRequest)) {
            return false;
        }
        CreateSecurityAttributeRequest other = (CreateSecurityAttributeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAttributeNamespaceId, other.securityAttributeNamespaceId) && Objects.equals((Object)this.createSecurityAttributeDetails, (Object)other.createSecurityAttributeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAttributeNamespaceId == null ? 43 : this.securityAttributeNamespaceId.hashCode());
        result = result * 59 + (this.createSecurityAttributeDetails == null ? 43 : this.createSecurityAttributeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateSecurityAttributeRequest, CreateSecurityAttributeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAttributeNamespaceId = null;
        private CreateSecurityAttributeDetails createSecurityAttributeDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder securityAttributeNamespaceId(String securityAttributeNamespaceId) {
            this.securityAttributeNamespaceId = securityAttributeNamespaceId;
            return this;
        }

        public Builder createSecurityAttributeDetails(CreateSecurityAttributeDetails createSecurityAttributeDetails) {
            this.createSecurityAttributeDetails = createSecurityAttributeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateSecurityAttributeRequest o) {
            this.securityAttributeNamespaceId(o.getSecurityAttributeNamespaceId());
            this.createSecurityAttributeDetails(o.getCreateSecurityAttributeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateSecurityAttributeRequest build() {
            CreateSecurityAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateSecurityAttributeDetails body) {
            this.createSecurityAttributeDetails(body);
            return this;
        }

        public CreateSecurityAttributeRequest buildWithoutInvocationCallback() {
            CreateSecurityAttributeRequest request = new CreateSecurityAttributeRequest();
            request.securityAttributeNamespaceId = this.securityAttributeNamespaceId;
            request.createSecurityAttributeDetails = this.createSecurityAttributeDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

