/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteSecurityAttributeRequest
extends BmcRequest<Void> {
    private String securityAttributeNamespaceId;
    private String securityAttributeName;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getSecurityAttributeNamespaceId() {
        return this.securityAttributeNamespaceId;
    }

    public String getSecurityAttributeName() {
        return this.securityAttributeName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().securityAttributeNamespaceId(this.securityAttributeNamespaceId).securityAttributeName(this.securityAttributeName).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAttributeNamespaceId=").append(String.valueOf(this.securityAttributeNamespaceId));
        sb.append(",securityAttributeName=").append(String.valueOf(this.securityAttributeName));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteSecurityAttributeRequest)) {
            return false;
        }
        DeleteSecurityAttributeRequest other = (DeleteSecurityAttributeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAttributeNamespaceId, other.securityAttributeNamespaceId) && Objects.equals(this.securityAttributeName, other.securityAttributeName) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAttributeNamespaceId == null ? 43 : this.securityAttributeNamespaceId.hashCode());
        result = result * 59 + (this.securityAttributeName == null ? 43 : this.securityAttributeName.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteSecurityAttributeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAttributeNamespaceId = null;
        private String securityAttributeName = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder securityAttributeNamespaceId(String securityAttributeNamespaceId) {
            this.securityAttributeNamespaceId = securityAttributeNamespaceId;
            return this;
        }

        public Builder securityAttributeName(String securityAttributeName) {
            this.securityAttributeName = securityAttributeName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSecurityAttributeRequest o) {
            this.securityAttributeNamespaceId(o.getSecurityAttributeNamespaceId());
            this.securityAttributeName(o.getSecurityAttributeName());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSecurityAttributeRequest build() {
            DeleteSecurityAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteSecurityAttributeRequest buildWithoutInvocationCallback() {
            DeleteSecurityAttributeRequest request = new DeleteSecurityAttributeRequest();
            request.securityAttributeNamespaceId = this.securityAttributeNamespaceId;
            request.securityAttributeName = this.securityAttributeName;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

