/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSecurityAttributeRequest
extends BmcRequest<Void> {
    private String securityAttributeNamespaceId;
    private String securityAttributeName;
    private String opcRequestId;

    public String getSecurityAttributeNamespaceId() {
        return this.securityAttributeNamespaceId;
    }

    public String getSecurityAttributeName() {
        return this.securityAttributeName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityAttributeNamespaceId(this.securityAttributeNamespaceId).securityAttributeName(this.securityAttributeName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAttributeNamespaceId=").append(String.valueOf(this.securityAttributeNamespaceId));
        sb.append(",securityAttributeName=").append(String.valueOf(this.securityAttributeName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSecurityAttributeRequest)) {
            return false;
        }
        GetSecurityAttributeRequest other = (GetSecurityAttributeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAttributeNamespaceId, other.securityAttributeNamespaceId) && Objects.equals(this.securityAttributeName, other.securityAttributeName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAttributeNamespaceId == null ? 43 : this.securityAttributeNamespaceId.hashCode());
        result = result * 59 + (this.securityAttributeName == null ? 43 : this.securityAttributeName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecurityAttributeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAttributeNamespaceId = null;
        private String securityAttributeName = null;
        private String opcRequestId = null;

        public Builder securityAttributeNamespaceId(String securityAttributeNamespaceId) {
            this.securityAttributeNamespaceId = securityAttributeNamespaceId;
            return this;
        }

        public Builder securityAttributeName(String securityAttributeName) {
            this.securityAttributeName = securityAttributeName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecurityAttributeRequest o) {
            this.securityAttributeNamespaceId(o.getSecurityAttributeNamespaceId());
            this.securityAttributeName(o.getSecurityAttributeName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecurityAttributeRequest build() {
            GetSecurityAttributeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSecurityAttributeRequest buildWithoutInvocationCallback() {
            GetSecurityAttributeRequest request = new GetSecurityAttributeRequest();
            request.securityAttributeNamespaceId = this.securityAttributeNamespaceId;
            request.securityAttributeName = this.securityAttributeName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

