/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.securityattribute.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.securityattribute.model.SecurityAttribute;
import java.util.Objects;

public class ListSecurityAttributesRequest
extends BmcRequest<Void> {
    private String securityAttributeNamespaceId;
    private String page;
    private Integer limit;
    private String opcRequestId;
    private SecurityAttribute.LifecycleState lifecycleState;

    public String getSecurityAttributeNamespaceId() {
        return this.securityAttributeNamespaceId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SecurityAttribute.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().securityAttributeNamespaceId(this.securityAttributeNamespaceId).page(this.page).limit(this.limit).opcRequestId(this.opcRequestId).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAttributeNamespaceId=").append(String.valueOf(this.securityAttributeNamespaceId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSecurityAttributesRequest)) {
            return false;
        }
        ListSecurityAttributesRequest other = (ListSecurityAttributesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAttributeNamespaceId, other.securityAttributeNamespaceId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAttributeNamespaceId == null ? 43 : this.securityAttributeNamespaceId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSecurityAttributesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAttributeNamespaceId = null;
        private String page = null;
        private Integer limit = null;
        private String opcRequestId = null;
        private SecurityAttribute.LifecycleState lifecycleState = null;

        public Builder securityAttributeNamespaceId(String securityAttributeNamespaceId) {
            this.securityAttributeNamespaceId = securityAttributeNamespaceId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lifecycleState(SecurityAttribute.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSecurityAttributesRequest o) {
            this.securityAttributeNamespaceId(o.getSecurityAttributeNamespaceId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSecurityAttributesRequest build() {
            ListSecurityAttributesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSecurityAttributesRequest buildWithoutInvocationCallback() {
            ListSecurityAttributesRequest request = new ListSecurityAttributesRequest();
            request.securityAttributeNamespaceId = this.securityAttributeNamespaceId;
            request.page = this.page;
            request.limit = this.limit;
            request.opcRequestId = this.opcRequestId;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }
}

