/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemanagerproxy.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ServiceDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="shortDisplayName")
    private final String shortDisplayName;

    @Deprecated
    @ConstructorProperties(value={"type", "displayName", "shortDisplayName"})
    public ServiceDefinition(String type, String displayName, String shortDisplayName) {
        this.type = type;
        this.displayName = displayName;
        this.shortDisplayName = shortDisplayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDisplayName() {
        return this.shortDisplayName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf(this.type));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", shortDisplayName=").append(String.valueOf(this.shortDisplayName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceDefinition)) {
            return false;
        }
        ServiceDefinition other = (ServiceDefinition)((Object)o);
        return Objects.equals(this.type, other.type) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.shortDisplayName, other.shortDisplayName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.shortDisplayName == null ? 43 : this.shortDisplayName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="shortDisplayName")
        private String shortDisplayName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder shortDisplayName(String shortDisplayName) {
            this.shortDisplayName = shortDisplayName;
            this.__explicitlySet__.add("shortDisplayName");
            return this;
        }

        public ServiceDefinition build() {
            ServiceDefinition model = new ServiceDefinition(this.type, this.displayName, this.shortDisplayName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ServiceDefinition model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("shortDisplayName")) {
                this.shortDisplayName(model.getShortDisplayName());
            }
            return this;
        }
    }
}

