/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemanagerproxy;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.servicemanagerproxy.ServiceManagerProxyAsync;
import com.oracle.bmc.servicemanagerproxy.model.ServiceEnvironment;
import com.oracle.bmc.servicemanagerproxy.model.ServiceEnvironmentCollection;
import com.oracle.bmc.servicemanagerproxy.requests.GetServiceEnvironmentRequest;
import com.oracle.bmc.servicemanagerproxy.requests.ListServiceEnvironmentsRequest;
import com.oracle.bmc.servicemanagerproxy.responses.GetServiceEnvironmentResponse;
import com.oracle.bmc.servicemanagerproxy.responses.ListServiceEnvironmentsResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManagerProxyAsyncClient
extends BaseAsyncClient
implements ServiceManagerProxyAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SERVICEMANAGERPROXY").serviceEndpointPrefix("").serviceEndpointTemplate("https://smproxy.{region}.ocs.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceManagerProxyAsyncClient.class);

    ServiceManagerProxyAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetServiceEnvironmentResponse> getServiceEnvironment(GetServiceEnvironmentRequest request, AsyncHandler<GetServiceEnvironmentRequest, GetServiceEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getServiceEnvironmentId(), (String)"serviceEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetServiceEnvironmentResponse::builder).logger(LOG, "getServiceEnvironment").serviceDetails("ServiceManagerProxy", "GetServiceEnvironment", "https://docs.oracle.com/iaas/api/#/en/smp/20210914/ServiceEnvironment/GetServiceEnvironment").method(Method.GET).requestBuilder(GetServiceEnvironmentRequest::builder).basePath("/20210914").appendPathParam("serviceEnvironments").appendPathParam(request.getServiceEnvironmentId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceEnvironment.class, GetServiceEnvironmentResponse.Builder::serviceEnvironment).handleResponseHeaderString("opc-request-id", GetServiceEnvironmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetServiceEnvironmentResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListServiceEnvironmentsResponse> listServiceEnvironments(ListServiceEnvironmentsRequest request, AsyncHandler<ListServiceEnvironmentsRequest, ListServiceEnvironmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListServiceEnvironmentsResponse::builder).logger(LOG, "listServiceEnvironments").serviceDetails("ServiceManagerProxy", "ListServiceEnvironments", "https://docs.oracle.com/iaas/api/#/en/smp/20210914/ServiceEnvironment/ListServiceEnvironments").method(Method.GET).requestBuilder(ListServiceEnvironmentsRequest::builder).basePath("/20210914").appendPathParam("serviceEnvironments").appendQueryParam("serviceEnvironmentId", (Object)request.getServiceEnvironmentId()).appendQueryParam("serviceEnvironmentType", (Object)request.getServiceEnvironmentType()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ServiceEnvironmentCollection.class, ListServiceEnvironmentsResponse.Builder::serviceEnvironmentCollection).handleResponseHeaderString("opc-request-id", ListServiceEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListServiceEnvironmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Deprecated
    public ServiceManagerProxyAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ServiceManagerProxyAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceManagerProxyAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ServiceManagerProxyAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceManagerProxyAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ServiceManagerProxyAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceManagerProxyAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ServiceManagerProxyAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceManagerProxyAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ServiceManagerProxyAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceManagerProxyAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ServiceManagerProxyAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceManagerProxyAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceManagerProxyAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ServiceManagerProxyAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "servicemanagerproxy";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"servicemanagerproxy");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ServiceManagerProxyAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ServiceManagerProxyAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

