/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.servicemesh.ServiceMeshAsync;
import com.oracle.bmc.servicemesh.model.AccessPolicy;
import com.oracle.bmc.servicemesh.model.AccessPolicyCollection;
import com.oracle.bmc.servicemesh.model.IngressGateway;
import com.oracle.bmc.servicemesh.model.IngressGatewayCollection;
import com.oracle.bmc.servicemesh.model.IngressGatewayRouteTable;
import com.oracle.bmc.servicemesh.model.IngressGatewayRouteTableCollection;
import com.oracle.bmc.servicemesh.model.Mesh;
import com.oracle.bmc.servicemesh.model.MeshCollection;
import com.oracle.bmc.servicemesh.model.ProxyDetails;
import com.oracle.bmc.servicemesh.model.VirtualDeployment;
import com.oracle.bmc.servicemesh.model.VirtualDeploymentCollection;
import com.oracle.bmc.servicemesh.model.VirtualService;
import com.oracle.bmc.servicemesh.model.VirtualServiceCollection;
import com.oracle.bmc.servicemesh.model.VirtualServiceRouteTable;
import com.oracle.bmc.servicemesh.model.VirtualServiceRouteTableCollection;
import com.oracle.bmc.servicemesh.model.WorkRequest;
import com.oracle.bmc.servicemesh.model.WorkRequestCollection;
import com.oracle.bmc.servicemesh.model.WorkRequestErrorCollection;
import com.oracle.bmc.servicemesh.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.servicemesh.requests.CancelWorkRequestRequest;
import com.oracle.bmc.servicemesh.requests.ChangeAccessPolicyCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeIngressGatewayCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeIngressGatewayRouteTableCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeMeshCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeVirtualDeploymentCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeVirtualServiceCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeVirtualServiceRouteTableCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.CreateAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.CreateIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.CreateIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.CreateMeshRequest;
import com.oracle.bmc.servicemesh.requests.CreateVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.CreateVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.CreateVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.DeleteAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.DeleteIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.DeleteIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.DeleteMeshRequest;
import com.oracle.bmc.servicemesh.requests.DeleteVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.DeleteVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.DeleteVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.GetIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.GetIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetMeshRequest;
import com.oracle.bmc.servicemesh.requests.GetProxyDetailsRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetWorkRequestRequest;
import com.oracle.bmc.servicemesh.requests.ListAccessPoliciesRequest;
import com.oracle.bmc.servicemesh.requests.ListIngressGatewayRouteTablesRequest;
import com.oracle.bmc.servicemesh.requests.ListIngressGatewaysRequest;
import com.oracle.bmc.servicemesh.requests.ListMeshesRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualDeploymentsRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualServiceRouteTablesRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualServicesRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestsRequest;
import com.oracle.bmc.servicemesh.requests.UpdateAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.UpdateIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.UpdateIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.UpdateMeshRequest;
import com.oracle.bmc.servicemesh.requests.UpdateVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.UpdateVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.UpdateVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.responses.CancelWorkRequestResponse;
import com.oracle.bmc.servicemesh.responses.ChangeAccessPolicyCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeIngressGatewayCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeIngressGatewayRouteTableCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeMeshCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeVirtualDeploymentCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeVirtualServiceCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeVirtualServiceRouteTableCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.CreateAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.CreateIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.CreateIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.CreateMeshResponse;
import com.oracle.bmc.servicemesh.responses.CreateVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.CreateVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.CreateVirtualServiceRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.DeleteAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.DeleteIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.DeleteIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.DeleteMeshResponse;
import com.oracle.bmc.servicemesh.responses.DeleteVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.DeleteVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.DeleteVirtualServiceRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.GetIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.GetIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetMeshResponse;
import com.oracle.bmc.servicemesh.responses.GetProxyDetailsResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualServiceRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetWorkRequestResponse;
import com.oracle.bmc.servicemesh.responses.ListAccessPoliciesResponse;
import com.oracle.bmc.servicemesh.responses.ListIngressGatewayRouteTablesResponse;
import com.oracle.bmc.servicemesh.responses.ListIngressGatewaysResponse;
import com.oracle.bmc.servicemesh.responses.ListMeshesResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualDeploymentsResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualServiceRouteTablesResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualServicesResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestsResponse;
import com.oracle.bmc.servicemesh.responses.UpdateAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.UpdateIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.UpdateIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.UpdateMeshResponse;
import com.oracle.bmc.servicemesh.responses.UpdateVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.UpdateVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.UpdateVirtualServiceRouteTableResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMeshAsyncClient
extends BaseAsyncClient
implements ServiceMeshAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SERVICEMESH").serviceEndpointPrefix("").serviceEndpointTemplate("https://servicemesh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMeshAsyncClient.class);

    ServiceMeshAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("ServiceMesh", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAccessPolicyCompartmentResponse> changeAccessPolicyCompartment(ChangeAccessPolicyCompartmentRequest request, AsyncHandler<ChangeAccessPolicyCompartmentRequest, ChangeAccessPolicyCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAccessPolicyCompartmentDetails(), "changeAccessPolicyCompartmentDetails is required");
        return this.clientCall(request, ChangeAccessPolicyCompartmentResponse::builder).logger(LOG, "changeAccessPolicyCompartment").serviceDetails("ServiceMesh", "ChangeAccessPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/ChangeAccessPolicyCompartment").method(Method.POST).requestBuilder(ChangeAccessPolicyCompartmentRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeAccessPolicyCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeAccessPolicyCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeIngressGatewayCompartmentResponse> changeIngressGatewayCompartment(ChangeIngressGatewayCompartmentRequest request, AsyncHandler<ChangeIngressGatewayCompartmentRequest, ChangeIngressGatewayCompartmentResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIngressGatewayCompartmentDetails(), "changeIngressGatewayCompartmentDetails is required");
        return this.clientCall(request, ChangeIngressGatewayCompartmentResponse::builder).logger(LOG, "changeIngressGatewayCompartment").serviceDetails("ServiceMesh", "ChangeIngressGatewayCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/ChangeIngressGatewayCompartment").method(Method.POST).requestBuilder(ChangeIngressGatewayCompartmentRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIngressGatewayCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIngressGatewayCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeIngressGatewayRouteTableCompartmentResponse> changeIngressGatewayRouteTableCompartment(ChangeIngressGatewayRouteTableCompartmentRequest request, AsyncHandler<ChangeIngressGatewayRouteTableCompartmentRequest, ChangeIngressGatewayRouteTableCompartmentResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIngressGatewayRouteTableCompartmentDetails(), "changeIngressGatewayRouteTableCompartmentDetails is required");
        return this.clientCall(request, ChangeIngressGatewayRouteTableCompartmentResponse::builder).logger(LOG, "changeIngressGatewayRouteTableCompartment").serviceDetails("ServiceMesh", "ChangeIngressGatewayRouteTableCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/ChangeIngressGatewayRouteTableCompartment").method(Method.POST).requestBuilder(ChangeIngressGatewayRouteTableCompartmentRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIngressGatewayRouteTableCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIngressGatewayRouteTableCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeMeshCompartmentResponse> changeMeshCompartment(ChangeMeshCompartmentRequest request, AsyncHandler<ChangeMeshCompartmentRequest, ChangeMeshCompartmentResponse> handler) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMeshCompartmentDetails(), "changeMeshCompartmentDetails is required");
        return this.clientCall(request, ChangeMeshCompartmentResponse::builder).logger(LOG, "changeMeshCompartment").serviceDetails("ServiceMesh", "ChangeMeshCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/ChangeMeshCompartment").method(Method.POST).requestBuilder(ChangeMeshCompartmentRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMeshCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMeshCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeVirtualDeploymentCompartmentResponse> changeVirtualDeploymentCompartment(ChangeVirtualDeploymentCompartmentRequest request, AsyncHandler<ChangeVirtualDeploymentCompartmentRequest, ChangeVirtualDeploymentCompartmentResponse> handler) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVirtualDeploymentCompartmentDetails(), "changeVirtualDeploymentCompartmentDetails is required");
        return this.clientCall(request, ChangeVirtualDeploymentCompartmentResponse::builder).logger(LOG, "changeVirtualDeploymentCompartment").serviceDetails("ServiceMesh", "ChangeVirtualDeploymentCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/ChangeVirtualDeploymentCompartment").method(Method.POST).requestBuilder(ChangeVirtualDeploymentCompartmentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVirtualDeploymentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVirtualDeploymentCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeVirtualServiceCompartmentResponse> changeVirtualServiceCompartment(ChangeVirtualServiceCompartmentRequest request, AsyncHandler<ChangeVirtualServiceCompartmentRequest, ChangeVirtualServiceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVirtualServiceCompartmentDetails(), "changeVirtualServiceCompartmentDetails is required");
        return this.clientCall(request, ChangeVirtualServiceCompartmentResponse::builder).logger(LOG, "changeVirtualServiceCompartment").serviceDetails("ServiceMesh", "ChangeVirtualServiceCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/ChangeVirtualServiceCompartment").method(Method.POST).requestBuilder(ChangeVirtualServiceCompartmentRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVirtualServiceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVirtualServiceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeVirtualServiceRouteTableCompartmentResponse> changeVirtualServiceRouteTableCompartment(ChangeVirtualServiceRouteTableCompartmentRequest request, AsyncHandler<ChangeVirtualServiceRouteTableCompartmentRequest, ChangeVirtualServiceRouteTableCompartmentResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVirtualServiceRouteTableCompartmentDetails(), "changeVirtualServiceRouteTableCompartmentDetails is required");
        return this.clientCall(request, ChangeVirtualServiceRouteTableCompartmentResponse::builder).logger(LOG, "changeVirtualServiceRouteTableCompartment").serviceDetails("ServiceMesh", "ChangeVirtualServiceRouteTableCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/ChangeVirtualServiceRouteTableCompartment").method(Method.POST).requestBuilder(ChangeVirtualServiceRouteTableCompartmentRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVirtualServiceRouteTableCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVirtualServiceRouteTableCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAccessPolicyResponse> createAccessPolicy(CreateAccessPolicyRequest request, AsyncHandler<CreateAccessPolicyRequest, CreateAccessPolicyResponse> handler) {
        Objects.requireNonNull(request.getCreateAccessPolicyDetails(), "createAccessPolicyDetails is required");
        return this.clientCall(request, CreateAccessPolicyResponse::builder).logger(LOG, "createAccessPolicy").serviceDetails("ServiceMesh", "CreateAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/CreateAccessPolicy").method(Method.POST).requestBuilder(CreateAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AccessPolicy.class, CreateAccessPolicyResponse.Builder::accessPolicy).handleResponseHeaderString("etag", CreateAccessPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateAccessPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateAccessPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateAccessPolicyResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateIngressGatewayResponse> createIngressGateway(CreateIngressGatewayRequest request, AsyncHandler<CreateIngressGatewayRequest, CreateIngressGatewayResponse> handler) {
        Objects.requireNonNull(request.getCreateIngressGatewayDetails(), "createIngressGatewayDetails is required");
        return this.clientCall(request, CreateIngressGatewayResponse::builder).logger(LOG, "createIngressGateway").serviceDetails("ServiceMesh", "CreateIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/CreateIngressGateway").method(Method.POST).requestBuilder(CreateIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IngressGateway.class, CreateIngressGatewayResponse.Builder::ingressGateway).handleResponseHeaderString("etag", CreateIngressGatewayResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateIngressGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateIngressGatewayResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateIngressGatewayResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateIngressGatewayRouteTableResponse> createIngressGatewayRouteTable(CreateIngressGatewayRouteTableRequest request, AsyncHandler<CreateIngressGatewayRouteTableRequest, CreateIngressGatewayRouteTableResponse> handler) {
        Objects.requireNonNull(request.getCreateIngressGatewayRouteTableDetails(), "createIngressGatewayRouteTableDetails is required");
        return this.clientCall(request, CreateIngressGatewayRouteTableResponse::builder).logger(LOG, "createIngressGatewayRouteTable").serviceDetails("ServiceMesh", "CreateIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/CreateIngressGatewayRouteTable").method(Method.POST).requestBuilder(CreateIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IngressGatewayRouteTable.class, CreateIngressGatewayRouteTableResponse.Builder::ingressGatewayRouteTable).handleResponseHeaderString("etag", CreateIngressGatewayRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateIngressGatewayRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateIngressGatewayRouteTableResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateIngressGatewayRouteTableResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateMeshResponse> createMesh(CreateMeshRequest request, AsyncHandler<CreateMeshRequest, CreateMeshResponse> handler) {
        Objects.requireNonNull(request.getCreateMeshDetails(), "createMeshDetails is required");
        return this.clientCall(request, CreateMeshResponse::builder).logger(LOG, "createMesh").serviceDetails("ServiceMesh", "CreateMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/CreateMesh").method(Method.POST).requestBuilder(CreateMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Mesh.class, CreateMeshResponse.Builder::mesh).handleResponseHeaderString("etag", CreateMeshResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateMeshResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateMeshResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateMeshResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateVirtualDeploymentResponse> createVirtualDeployment(CreateVirtualDeploymentRequest request, AsyncHandler<CreateVirtualDeploymentRequest, CreateVirtualDeploymentResponse> handler) {
        Objects.requireNonNull(request.getCreateVirtualDeploymentDetails(), "createVirtualDeploymentDetails is required");
        return this.clientCall(request, CreateVirtualDeploymentResponse::builder).logger(LOG, "createVirtualDeployment").serviceDetails("ServiceMesh", "CreateVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/CreateVirtualDeployment").method(Method.POST).requestBuilder(CreateVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VirtualDeployment.class, CreateVirtualDeploymentResponse.Builder::virtualDeployment).handleResponseHeaderString("etag", CreateVirtualDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateVirtualDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualDeploymentResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateVirtualDeploymentResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateVirtualServiceResponse> createVirtualService(CreateVirtualServiceRequest request, AsyncHandler<CreateVirtualServiceRequest, CreateVirtualServiceResponse> handler) {
        Objects.requireNonNull(request.getCreateVirtualServiceDetails(), "createVirtualServiceDetails is required");
        return this.clientCall(request, CreateVirtualServiceResponse::builder).logger(LOG, "createVirtualService").serviceDetails("ServiceMesh", "CreateVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/CreateVirtualService").method(Method.POST).requestBuilder(CreateVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VirtualService.class, CreateVirtualServiceResponse.Builder::virtualService).handleResponseHeaderString("etag", CreateVirtualServiceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateVirtualServiceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualServiceResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateVirtualServiceResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateVirtualServiceRouteTableResponse> createVirtualServiceRouteTable(CreateVirtualServiceRouteTableRequest request, AsyncHandler<CreateVirtualServiceRouteTableRequest, CreateVirtualServiceRouteTableResponse> handler) {
        Objects.requireNonNull(request.getCreateVirtualServiceRouteTableDetails(), "createVirtualServiceRouteTableDetails is required");
        return this.clientCall(request, CreateVirtualServiceRouteTableResponse::builder).logger(LOG, "createVirtualServiceRouteTable").serviceDetails("ServiceMesh", "CreateVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/CreateVirtualServiceRouteTable").method(Method.POST).requestBuilder(CreateVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(VirtualServiceRouteTable.class, CreateVirtualServiceRouteTableResponse.Builder::virtualServiceRouteTable).handleResponseHeaderString("etag", CreateVirtualServiceRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateVirtualServiceRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualServiceRouteTableResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateVirtualServiceRouteTableResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteAccessPolicyResponse> deleteAccessPolicy(DeleteAccessPolicyRequest request, AsyncHandler<DeleteAccessPolicyRequest, DeleteAccessPolicyResponse> handler) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAccessPolicyResponse::builder).logger(LOG, "deleteAccessPolicy").serviceDetails("ServiceMesh", "DeleteAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/DeleteAccessPolicy").method(Method.DELETE).requestBuilder(DeleteAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteAccessPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteAccessPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteIngressGatewayResponse> deleteIngressGateway(DeleteIngressGatewayRequest request, AsyncHandler<DeleteIngressGatewayRequest, DeleteIngressGatewayResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteIngressGatewayResponse::builder).logger(LOG, "deleteIngressGateway").serviceDetails("ServiceMesh", "DeleteIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/DeleteIngressGateway").method(Method.DELETE).requestBuilder(DeleteIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteIngressGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteIngressGatewayResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteIngressGatewayRouteTableResponse> deleteIngressGatewayRouteTable(DeleteIngressGatewayRouteTableRequest request, AsyncHandler<DeleteIngressGatewayRouteTableRequest, DeleteIngressGatewayRouteTableResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteIngressGatewayRouteTableResponse::builder).logger(LOG, "deleteIngressGatewayRouteTable").serviceDetails("ServiceMesh", "DeleteIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/DeleteIngressGatewayRouteTable").method(Method.DELETE).requestBuilder(DeleteIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteIngressGatewayRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteIngressGatewayRouteTableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteMeshResponse> deleteMesh(DeleteMeshRequest request, AsyncHandler<DeleteMeshRequest, DeleteMeshResponse> handler) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteMeshResponse::builder).logger(LOG, "deleteMesh").serviceDetails("ServiceMesh", "DeleteMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/DeleteMesh").method(Method.DELETE).requestBuilder(DeleteMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteMeshResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMeshResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVirtualDeploymentResponse> deleteVirtualDeployment(DeleteVirtualDeploymentRequest request, AsyncHandler<DeleteVirtualDeploymentRequest, DeleteVirtualDeploymentResponse> handler) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteVirtualDeploymentResponse::builder).logger(LOG, "deleteVirtualDeployment").serviceDetails("ServiceMesh", "DeleteVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/DeleteVirtualDeployment").method(Method.DELETE).requestBuilder(DeleteVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVirtualDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVirtualServiceResponse> deleteVirtualService(DeleteVirtualServiceRequest request, AsyncHandler<DeleteVirtualServiceRequest, DeleteVirtualServiceResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteVirtualServiceResponse::builder).logger(LOG, "deleteVirtualService").serviceDetails("ServiceMesh", "DeleteVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/DeleteVirtualService").method(Method.DELETE).requestBuilder(DeleteVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVirtualServiceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualServiceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVirtualServiceRouteTableResponse> deleteVirtualServiceRouteTable(DeleteVirtualServiceRouteTableRequest request, AsyncHandler<DeleteVirtualServiceRouteTableRequest, DeleteVirtualServiceRouteTableResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteVirtualServiceRouteTableResponse::builder).logger(LOG, "deleteVirtualServiceRouteTable").serviceDetails("ServiceMesh", "DeleteVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/DeleteVirtualServiceRouteTable").method(Method.DELETE).requestBuilder(DeleteVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVirtualServiceRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualServiceRouteTableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAccessPolicyResponse> getAccessPolicy(GetAccessPolicyRequest request, AsyncHandler<GetAccessPolicyRequest, GetAccessPolicyResponse> handler) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAccessPolicyResponse::builder).logger(LOG, "getAccessPolicy").serviceDetails("ServiceMesh", "GetAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/GetAccessPolicy").method(Method.GET).requestBuilder(GetAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AccessPolicy.class, GetAccessPolicyResponse.Builder::accessPolicy).handleResponseHeaderString("etag", GetAccessPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAccessPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetIngressGatewayResponse> getIngressGateway(GetIngressGatewayRequest request, AsyncHandler<GetIngressGatewayRequest, GetIngressGatewayResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetIngressGatewayResponse::builder).logger(LOG, "getIngressGateway").serviceDetails("ServiceMesh", "GetIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/GetIngressGateway").method(Method.GET).requestBuilder(GetIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IngressGateway.class, GetIngressGatewayResponse.Builder::ingressGateway).handleResponseHeaderString("etag", GetIngressGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIngressGatewayResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetIngressGatewayRouteTableResponse> getIngressGatewayRouteTable(GetIngressGatewayRouteTableRequest request, AsyncHandler<GetIngressGatewayRouteTableRequest, GetIngressGatewayRouteTableResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetIngressGatewayRouteTableResponse::builder).logger(LOG, "getIngressGatewayRouteTable").serviceDetails("ServiceMesh", "GetIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/GetIngressGatewayRouteTable").method(Method.GET).requestBuilder(GetIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IngressGatewayRouteTable.class, GetIngressGatewayRouteTableResponse.Builder::ingressGatewayRouteTable).handleResponseHeaderString("etag", GetIngressGatewayRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIngressGatewayRouteTableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMeshResponse> getMesh(GetMeshRequest request, AsyncHandler<GetMeshRequest, GetMeshResponse> handler) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMeshResponse::builder).logger(LOG, "getMesh").serviceDetails("ServiceMesh", "GetMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/GetMesh").method(Method.GET).requestBuilder(GetMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Mesh.class, GetMeshResponse.Builder::mesh).handleResponseHeaderString("etag", GetMeshResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMeshResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProxyDetailsResponse> getProxyDetails(GetProxyDetailsRequest request, AsyncHandler<GetProxyDetailsRequest, GetProxyDetailsResponse> handler) {
        return this.clientCall(request, GetProxyDetailsResponse::builder).logger(LOG, "getProxyDetails").serviceDetails("ServiceMesh", "GetProxyDetails", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/ProxyDetails/GetProxyDetails").method(Method.GET).requestBuilder(GetProxyDetailsRequest::builder).basePath("/20220615").appendPathParam("proxyDetails").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProxyDetails.class, GetProxyDetailsResponse.Builder::proxyDetails).handleResponseHeaderString("opc-request-id", GetProxyDetailsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVirtualDeploymentResponse> getVirtualDeployment(GetVirtualDeploymentRequest request, AsyncHandler<GetVirtualDeploymentRequest, GetVirtualDeploymentResponse> handler) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVirtualDeploymentResponse::builder).logger(LOG, "getVirtualDeployment").serviceDetails("ServiceMesh", "GetVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/GetVirtualDeployment").method(Method.GET).requestBuilder(GetVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualDeployment.class, GetVirtualDeploymentResponse.Builder::virtualDeployment).handleResponseHeaderString("etag", GetVirtualDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVirtualServiceResponse> getVirtualService(GetVirtualServiceRequest request, AsyncHandler<GetVirtualServiceRequest, GetVirtualServiceResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVirtualServiceResponse::builder).logger(LOG, "getVirtualService").serviceDetails("ServiceMesh", "GetVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/GetVirtualService").method(Method.GET).requestBuilder(GetVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualService.class, GetVirtualServiceResponse.Builder::virtualService).handleResponseHeaderString("etag", GetVirtualServiceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualServiceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVirtualServiceRouteTableResponse> getVirtualServiceRouteTable(GetVirtualServiceRouteTableRequest request, AsyncHandler<GetVirtualServiceRouteTableRequest, GetVirtualServiceRouteTableResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVirtualServiceRouteTableResponse::builder).logger(LOG, "getVirtualServiceRouteTable").serviceDetails("ServiceMesh", "GetVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/GetVirtualServiceRouteTable").method(Method.GET).requestBuilder(GetVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualServiceRouteTable.class, GetVirtualServiceRouteTableResponse.Builder::virtualServiceRouteTable).handleResponseHeaderString("etag", GetVirtualServiceRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualServiceRouteTableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ServiceMesh", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAccessPoliciesResponse> listAccessPolicies(ListAccessPoliciesRequest request, AsyncHandler<ListAccessPoliciesRequest, ListAccessPoliciesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAccessPoliciesResponse::builder).logger(LOG, "listAccessPolicies").serviceDetails("ServiceMesh", "ListAccessPolicies", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/ListAccessPolicies").method(Method.GET).requestBuilder(ListAccessPoliciesRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("meshId", (Object)request.getMeshId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AccessPolicyCollection.class, ListAccessPoliciesResponse.Builder::accessPolicyCollection).handleResponseHeaderString("opc-request-id", ListAccessPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAccessPoliciesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIngressGatewayRouteTablesResponse> listIngressGatewayRouteTables(ListIngressGatewayRouteTablesRequest request, AsyncHandler<ListIngressGatewayRouteTablesRequest, ListIngressGatewayRouteTablesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListIngressGatewayRouteTablesResponse::builder).logger(LOG, "listIngressGatewayRouteTables").serviceDetails("ServiceMesh", "ListIngressGatewayRouteTables", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/ListIngressGatewayRouteTables").method(Method.GET).requestBuilder(ListIngressGatewayRouteTablesRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("ingressGatewayId", (Object)request.getIngressGatewayId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IngressGatewayRouteTableCollection.class, ListIngressGatewayRouteTablesResponse.Builder::ingressGatewayRouteTableCollection).handleResponseHeaderString("opc-request-id", ListIngressGatewayRouteTablesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIngressGatewayRouteTablesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIngressGatewaysResponse> listIngressGateways(ListIngressGatewaysRequest request, AsyncHandler<ListIngressGatewaysRequest, ListIngressGatewaysResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListIngressGatewaysResponse::builder).logger(LOG, "listIngressGateways").serviceDetails("ServiceMesh", "ListIngressGateways", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/ListIngressGateways").method(Method.GET).requestBuilder(ListIngressGatewaysRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("meshId", (Object)request.getMeshId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IngressGatewayCollection.class, ListIngressGatewaysResponse.Builder::ingressGatewayCollection).handleResponseHeaderString("opc-request-id", ListIngressGatewaysResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIngressGatewaysResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMeshesResponse> listMeshes(ListMeshesRequest request, AsyncHandler<ListMeshesRequest, ListMeshesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListMeshesResponse::builder).logger(LOG, "listMeshes").serviceDetails("ServiceMesh", "ListMeshes", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/ListMeshes").method(Method.GET).requestBuilder(ListMeshesRequest::builder).basePath("/20220615").appendPathParam("meshes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MeshCollection.class, ListMeshesResponse.Builder::meshCollection).handleResponseHeaderString("opc-request-id", ListMeshesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMeshesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListVirtualDeploymentsResponse> listVirtualDeployments(ListVirtualDeploymentsRequest request, AsyncHandler<ListVirtualDeploymentsRequest, ListVirtualDeploymentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVirtualDeploymentsResponse::builder).logger(LOG, "listVirtualDeployments").serviceDetails("ServiceMesh", "ListVirtualDeployments", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/ListVirtualDeployments").method(Method.GET).requestBuilder(ListVirtualDeploymentsRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("virtualServiceId", (Object)request.getVirtualServiceId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualDeploymentCollection.class, ListVirtualDeploymentsResponse.Builder::virtualDeploymentCollection).handleResponseHeaderString("opc-request-id", ListVirtualDeploymentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVirtualDeploymentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListVirtualServiceRouteTablesResponse> listVirtualServiceRouteTables(ListVirtualServiceRouteTablesRequest request, AsyncHandler<ListVirtualServiceRouteTablesRequest, ListVirtualServiceRouteTablesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVirtualServiceRouteTablesResponse::builder).logger(LOG, "listVirtualServiceRouteTables").serviceDetails("ServiceMesh", "ListVirtualServiceRouteTables", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/ListVirtualServiceRouteTables").method(Method.GET).requestBuilder(ListVirtualServiceRouteTablesRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("virtualServiceId", (Object)request.getVirtualServiceId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualServiceRouteTableCollection.class, ListVirtualServiceRouteTablesResponse.Builder::virtualServiceRouteTableCollection).handleResponseHeaderString("opc-request-id", ListVirtualServiceRouteTablesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVirtualServiceRouteTablesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListVirtualServicesResponse> listVirtualServices(ListVirtualServicesRequest request, AsyncHandler<ListVirtualServicesRequest, ListVirtualServicesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVirtualServicesResponse::builder).logger(LOG, "listVirtualServices").serviceDetails("ServiceMesh", "ListVirtualServices", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/ListVirtualServices").method(Method.GET).requestBuilder(ListVirtualServicesRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("meshId", (Object)request.getMeshId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualServiceCollection.class, ListVirtualServicesResponse.Builder::virtualServiceCollection).handleResponseHeaderString("opc-request-id", ListVirtualServicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVirtualServicesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ServiceMesh", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ServiceMesh", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ServiceMesh", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("operationStatus", (BmcEnum)request.getOperationStatus()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateAccessPolicyResponse> updateAccessPolicy(UpdateAccessPolicyRequest request, AsyncHandler<UpdateAccessPolicyRequest, UpdateAccessPolicyResponse> handler) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAccessPolicyDetails(), "updateAccessPolicyDetails is required");
        return this.clientCall(request, UpdateAccessPolicyResponse::builder).logger(LOG, "updateAccessPolicy").serviceDetails("ServiceMesh", "UpdateAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/UpdateAccessPolicy").method(Method.PUT).requestBuilder(UpdateAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAccessPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAccessPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateIngressGatewayResponse> updateIngressGateway(UpdateIngressGatewayRequest request, AsyncHandler<UpdateIngressGatewayRequest, UpdateIngressGatewayResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIngressGatewayDetails(), "updateIngressGatewayDetails is required");
        return this.clientCall(request, UpdateIngressGatewayResponse::builder).logger(LOG, "updateIngressGateway").serviceDetails("ServiceMesh", "UpdateIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/UpdateIngressGateway").method(Method.PUT).requestBuilder(UpdateIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateIngressGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateIngressGatewayResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateIngressGatewayRouteTableResponse> updateIngressGatewayRouteTable(UpdateIngressGatewayRouteTableRequest request, AsyncHandler<UpdateIngressGatewayRouteTableRequest, UpdateIngressGatewayRouteTableResponse> handler) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIngressGatewayRouteTableDetails(), "updateIngressGatewayRouteTableDetails is required");
        return this.clientCall(request, UpdateIngressGatewayRouteTableResponse::builder).logger(LOG, "updateIngressGatewayRouteTable").serviceDetails("ServiceMesh", "UpdateIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/UpdateIngressGatewayRouteTable").method(Method.PUT).requestBuilder(UpdateIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateIngressGatewayRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateIngressGatewayRouteTableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateMeshResponse> updateMesh(UpdateMeshRequest request, AsyncHandler<UpdateMeshRequest, UpdateMeshResponse> handler) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMeshDetails(), "updateMeshDetails is required");
        return this.clientCall(request, UpdateMeshResponse::builder).logger(LOG, "updateMesh").serviceDetails("ServiceMesh", "UpdateMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/UpdateMesh").method(Method.PUT).requestBuilder(UpdateMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateMeshResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateMeshResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVirtualDeploymentResponse> updateVirtualDeployment(UpdateVirtualDeploymentRequest request, AsyncHandler<UpdateVirtualDeploymentRequest, UpdateVirtualDeploymentResponse> handler) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualDeploymentDetails(), "updateVirtualDeploymentDetails is required");
        return this.clientCall(request, UpdateVirtualDeploymentResponse::builder).logger(LOG, "updateVirtualDeployment").serviceDetails("ServiceMesh", "UpdateVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/UpdateVirtualDeployment").method(Method.PUT).requestBuilder(UpdateVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualDeploymentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVirtualServiceResponse> updateVirtualService(UpdateVirtualServiceRequest request, AsyncHandler<UpdateVirtualServiceRequest, UpdateVirtualServiceResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualServiceDetails(), "updateVirtualServiceDetails is required");
        return this.clientCall(request, UpdateVirtualServiceResponse::builder).logger(LOG, "updateVirtualService").serviceDetails("ServiceMesh", "UpdateVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/UpdateVirtualService").method(Method.PUT).requestBuilder(UpdateVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualServiceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualServiceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVirtualServiceRouteTableResponse> updateVirtualServiceRouteTable(UpdateVirtualServiceRouteTableRequest request, AsyncHandler<UpdateVirtualServiceRouteTableRequest, UpdateVirtualServiceRouteTableResponse> handler) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualServiceRouteTableDetails(), "updateVirtualServiceRouteTableDetails is required");
        return this.clientCall(request, UpdateVirtualServiceRouteTableResponse::builder).logger(LOG, "updateVirtualServiceRouteTable").serviceDetails("ServiceMesh", "UpdateVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/UpdateVirtualServiceRouteTable").method(Method.PUT).requestBuilder(UpdateVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualServiceRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualServiceRouteTableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ServiceMeshAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ServiceMeshAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceMeshAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ServiceMeshAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceMeshAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ServiceMeshAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceMeshAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ServiceMeshAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceMeshAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ServiceMeshAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceMeshAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ServiceMeshAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ServiceMeshAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceMeshAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ServiceMeshAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "servicemesh";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"servicemesh");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ServiceMeshAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ServiceMeshAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

