/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.servicemesh.model.AccessLoggingConfiguration;
import com.oracle.bmc.servicemesh.model.IngressGatewayHost;
import com.oracle.bmc.servicemesh.model.IngressGatewayMutualTransportLayerSecurityDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateIngressGatewayDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="meshId")
    private final String meshId;
    @JsonProperty(value="hosts")
    private final List<IngressGatewayHost> hosts;
    @JsonProperty(value="accessLogging")
    private final AccessLoggingConfiguration accessLogging;
    @JsonProperty(value="mtls")
    private final IngressGatewayMutualTransportLayerSecurityDetails mtls;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "meshId", "hosts", "accessLogging", "mtls", "compartmentId", "freeformTags", "definedTags"})
    public CreateIngressGatewayDetails(String name, String description, String meshId, List<IngressGatewayHost> hosts, AccessLoggingConfiguration accessLogging, IngressGatewayMutualTransportLayerSecurityDetails mtls, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.name = name;
        this.description = description;
        this.meshId = meshId;
        this.hosts = hosts;
        this.accessLogging = accessLogging;
        this.mtls = mtls;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMeshId() {
        return this.meshId;
    }

    public List<IngressGatewayHost> getHosts() {
        return this.hosts;
    }

    public AccessLoggingConfiguration getAccessLogging() {
        return this.accessLogging;
    }

    public IngressGatewayMutualTransportLayerSecurityDetails getMtls() {
        return this.mtls;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateIngressGatewayDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", meshId=").append(String.valueOf(this.meshId));
        sb.append(", hosts=").append(String.valueOf(this.hosts));
        sb.append(", accessLogging=").append(String.valueOf((Object)this.accessLogging));
        sb.append(", mtls=").append(String.valueOf((Object)this.mtls));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateIngressGatewayDetails)) {
            return false;
        }
        CreateIngressGatewayDetails other = (CreateIngressGatewayDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.meshId, other.meshId) && Objects.equals(this.hosts, other.hosts) && Objects.equals((Object)this.accessLogging, (Object)other.accessLogging) && Objects.equals((Object)this.mtls, (Object)other.mtls) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.meshId == null ? 43 : this.meshId.hashCode());
        result = result * 59 + (this.hosts == null ? 43 : this.hosts.hashCode());
        result = result * 59 + (this.accessLogging == null ? 43 : this.accessLogging.hashCode());
        result = result * 59 + (this.mtls == null ? 43 : this.mtls.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="meshId")
        private String meshId;
        @JsonProperty(value="hosts")
        private List<IngressGatewayHost> hosts;
        @JsonProperty(value="accessLogging")
        private AccessLoggingConfiguration accessLogging;
        @JsonProperty(value="mtls")
        private IngressGatewayMutualTransportLayerSecurityDetails mtls;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder meshId(String meshId) {
            this.meshId = meshId;
            this.__explicitlySet__.add("meshId");
            return this;
        }

        public Builder hosts(List<IngressGatewayHost> hosts) {
            this.hosts = hosts;
            this.__explicitlySet__.add("hosts");
            return this;
        }

        public Builder accessLogging(AccessLoggingConfiguration accessLogging) {
            this.accessLogging = accessLogging;
            this.__explicitlySet__.add("accessLogging");
            return this;
        }

        public Builder mtls(IngressGatewayMutualTransportLayerSecurityDetails mtls) {
            this.mtls = mtls;
            this.__explicitlySet__.add("mtls");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateIngressGatewayDetails build() {
            CreateIngressGatewayDetails model = new CreateIngressGatewayDetails(this.name, this.description, this.meshId, this.hosts, this.accessLogging, this.mtls, this.compartmentId, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateIngressGatewayDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("meshId")) {
                this.meshId(model.getMeshId());
            }
            if (model.wasPropertyExplicitlySet("hosts")) {
                this.hosts(model.getHosts());
            }
            if (model.wasPropertyExplicitlySet("accessLogging")) {
                this.accessLogging(model.getAccessLogging());
            }
            if (model.wasPropertyExplicitlySet("mtls")) {
                this.mtls(model.getMtls());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

