/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.servicemesh.model.AccessPolicyTarget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalServiceAccessPolicyTarget
extends AccessPolicyTarget {
    @JsonProperty(value="hostnames")
    private final List<String> hostnames;
    @JsonProperty(value="ipAddresses")
    private final List<String> ipAddresses;
    @JsonProperty(value="ports")
    private final List<Integer> ports;
    @JsonProperty(value="protocol")
    private final Protocol protocol;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalServiceAccessPolicyTarget(List<String> hostnames, List<String> ipAddresses, List<Integer> ports, Protocol protocol) {
        this.hostnames = hostnames;
        this.ipAddresses = ipAddresses;
        this.ports = ports;
        this.protocol = protocol;
    }

    public List<String> getHostnames() {
        return this.hostnames;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalServiceAccessPolicyTarget(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", hostnames=").append(String.valueOf(this.hostnames));
        sb.append(", ipAddresses=").append(String.valueOf(this.ipAddresses));
        sb.append(", ports=").append(String.valueOf(this.ports));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalServiceAccessPolicyTarget)) {
            return false;
        }
        ExternalServiceAccessPolicyTarget other = (ExternalServiceAccessPolicyTarget)((Object)o);
        return Objects.equals(this.hostnames, other.hostnames) && Objects.equals(this.ipAddresses, other.ipAddresses) && Objects.equals(this.ports, other.ports) && Objects.equals((Object)this.protocol, (Object)other.protocol) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hostnames == null ? 43 : this.hostnames.hashCode());
        result = result * 59 + (this.ipAddresses == null ? 43 : this.ipAddresses.hashCode());
        result = result * 59 + (this.ports == null ? 43 : this.ports.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        return result;
    }

    public static enum Protocol implements BmcEnum
    {
        Http("HTTP"),
        Https("HTTPS"),
        Tcp("TCP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostnames")
        private List<String> hostnames;
        @JsonProperty(value="ipAddresses")
        private List<String> ipAddresses;
        @JsonProperty(value="ports")
        private List<Integer> ports;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostnames(List<String> hostnames) {
            this.hostnames = hostnames;
            this.__explicitlySet__.add("hostnames");
            return this;
        }

        public Builder ipAddresses(List<String> ipAddresses) {
            this.ipAddresses = ipAddresses;
            this.__explicitlySet__.add("ipAddresses");
            return this;
        }

        public Builder ports(List<Integer> ports) {
            this.ports = ports;
            this.__explicitlySet__.add("ports");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public ExternalServiceAccessPolicyTarget build() {
            ExternalServiceAccessPolicyTarget model = new ExternalServiceAccessPolicyTarget(this.hostnames, this.ipAddresses, this.ports, this.protocol);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalServiceAccessPolicyTarget model) {
            if (model.wasPropertyExplicitlySet("hostnames")) {
                this.hostnames(model.getHostnames());
            }
            if (model.wasPropertyExplicitlySet("ipAddresses")) {
                this.ipAddresses(model.getIpAddresses());
            }
            if (model.wasPropertyExplicitlySet("ports")) {
                this.ports(model.getPorts());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            return this;
        }
    }
}

