/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.servicemesh.model.IngressGatewayHostRef;
import com.oracle.bmc.servicemesh.model.IngressGatewayTrafficRouteRuleDetails;
import com.oracle.bmc.servicemesh.model.VirtualServiceTrafficRuleTargetDetails;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class HttpIngressGatewayTrafficRouteRuleDetails
extends IngressGatewayTrafficRouteRuleDetails {
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="pathType")
    private final PathType pathType;
    @JsonProperty(value="isGrpc")
    private final Boolean isGrpc;
    @JsonProperty(value="isHostRewriteEnabled")
    private final Boolean isHostRewriteEnabled;
    @JsonProperty(value="isPathRewriteEnabled")
    private final Boolean isPathRewriteEnabled;
    @JsonProperty(value="requestTimeoutInMs")
    private final Long requestTimeoutInMs;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HttpIngressGatewayTrafficRouteRuleDetails(IngressGatewayHostRef ingressGatewayHost, List<VirtualServiceTrafficRuleTargetDetails> destinations, String path, PathType pathType, Boolean isGrpc, Boolean isHostRewriteEnabled, Boolean isPathRewriteEnabled, Long requestTimeoutInMs) {
        super(ingressGatewayHost, destinations);
        this.path = path;
        this.pathType = pathType;
        this.isGrpc = isGrpc;
        this.isHostRewriteEnabled = isHostRewriteEnabled;
        this.isPathRewriteEnabled = isPathRewriteEnabled;
        this.requestTimeoutInMs = requestTimeoutInMs;
    }

    public String getPath() {
        return this.path;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public Boolean getIsGrpc() {
        return this.isGrpc;
    }

    public Boolean getIsHostRewriteEnabled() {
        return this.isHostRewriteEnabled;
    }

    public Boolean getIsPathRewriteEnabled() {
        return this.isPathRewriteEnabled;
    }

    public Long getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpIngressGatewayTrafficRouteRuleDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", pathType=").append(String.valueOf((Object)this.pathType));
        sb.append(", isGrpc=").append(String.valueOf(this.isGrpc));
        sb.append(", isHostRewriteEnabled=").append(String.valueOf(this.isHostRewriteEnabled));
        sb.append(", isPathRewriteEnabled=").append(String.valueOf(this.isPathRewriteEnabled));
        sb.append(", requestTimeoutInMs=").append(String.valueOf(this.requestTimeoutInMs));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpIngressGatewayTrafficRouteRuleDetails)) {
            return false;
        }
        HttpIngressGatewayTrafficRouteRuleDetails other = (HttpIngressGatewayTrafficRouteRuleDetails)((Object)o);
        return Objects.equals(this.path, other.path) && Objects.equals((Object)this.pathType, (Object)other.pathType) && Objects.equals(this.isGrpc, other.isGrpc) && Objects.equals(this.isHostRewriteEnabled, other.isHostRewriteEnabled) && Objects.equals(this.isPathRewriteEnabled, other.isPathRewriteEnabled) && Objects.equals(this.requestTimeoutInMs, other.requestTimeoutInMs) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.pathType == null ? 43 : this.pathType.hashCode());
        result = result * 59 + (this.isGrpc == null ? 43 : this.isGrpc.hashCode());
        result = result * 59 + (this.isHostRewriteEnabled == null ? 43 : this.isHostRewriteEnabled.hashCode());
        result = result * 59 + (this.isPathRewriteEnabled == null ? 43 : this.isPathRewriteEnabled.hashCode());
        result = result * 59 + (this.requestTimeoutInMs == null ? 43 : this.requestTimeoutInMs.hashCode());
        return result;
    }

    public static enum PathType implements BmcEnum
    {
        Prefix("PREFIX");

        private final String value;
        private static Map<String, PathType> map;

        private PathType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PathType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PathType: " + key);
        }

        static {
            map = new HashMap<String, PathType>();
            for (PathType v : PathType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ingressGatewayHost")
        private IngressGatewayHostRef ingressGatewayHost;
        @JsonProperty(value="destinations")
        private List<VirtualServiceTrafficRuleTargetDetails> destinations;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="pathType")
        private PathType pathType;
        @JsonProperty(value="isGrpc")
        private Boolean isGrpc;
        @JsonProperty(value="isHostRewriteEnabled")
        private Boolean isHostRewriteEnabled;
        @JsonProperty(value="isPathRewriteEnabled")
        private Boolean isPathRewriteEnabled;
        @JsonProperty(value="requestTimeoutInMs")
        private Long requestTimeoutInMs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ingressGatewayHost(IngressGatewayHostRef ingressGatewayHost) {
            this.ingressGatewayHost = ingressGatewayHost;
            this.__explicitlySet__.add("ingressGatewayHost");
            return this;
        }

        public Builder destinations(List<VirtualServiceTrafficRuleTargetDetails> destinations) {
            this.destinations = destinations;
            this.__explicitlySet__.add("destinations");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder pathType(PathType pathType) {
            this.pathType = pathType;
            this.__explicitlySet__.add("pathType");
            return this;
        }

        public Builder isGrpc(Boolean isGrpc) {
            this.isGrpc = isGrpc;
            this.__explicitlySet__.add("isGrpc");
            return this;
        }

        public Builder isHostRewriteEnabled(Boolean isHostRewriteEnabled) {
            this.isHostRewriteEnabled = isHostRewriteEnabled;
            this.__explicitlySet__.add("isHostRewriteEnabled");
            return this;
        }

        public Builder isPathRewriteEnabled(Boolean isPathRewriteEnabled) {
            this.isPathRewriteEnabled = isPathRewriteEnabled;
            this.__explicitlySet__.add("isPathRewriteEnabled");
            return this;
        }

        public Builder requestTimeoutInMs(Long requestTimeoutInMs) {
            this.requestTimeoutInMs = requestTimeoutInMs;
            this.__explicitlySet__.add("requestTimeoutInMs");
            return this;
        }

        public HttpIngressGatewayTrafficRouteRuleDetails build() {
            HttpIngressGatewayTrafficRouteRuleDetails model = new HttpIngressGatewayTrafficRouteRuleDetails(this.ingressGatewayHost, this.destinations, this.path, this.pathType, this.isGrpc, this.isHostRewriteEnabled, this.isPathRewriteEnabled, this.requestTimeoutInMs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HttpIngressGatewayTrafficRouteRuleDetails model) {
            if (model.wasPropertyExplicitlySet("ingressGatewayHost")) {
                this.ingressGatewayHost(model.getIngressGatewayHost());
            }
            if (model.wasPropertyExplicitlySet("destinations")) {
                this.destinations(model.getDestinations());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("pathType")) {
                this.pathType(model.getPathType());
            }
            if (model.wasPropertyExplicitlySet("isGrpc")) {
                this.isGrpc(model.getIsGrpc());
            }
            if (model.wasPropertyExplicitlySet("isHostRewriteEnabled")) {
                this.isHostRewriteEnabled(model.getIsHostRewriteEnabled());
            }
            if (model.wasPropertyExplicitlySet("isPathRewriteEnabled")) {
                this.isPathRewriteEnabled(model.getIsPathRewriteEnabled());
            }
            if (model.wasPropertyExplicitlySet("requestTimeoutInMs")) {
                this.requestTimeoutInMs(model.getRequestTimeoutInMs());
            }
            return this;
        }
    }
}

