/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.servicemesh.model.AccessLoggingConfiguration;
import com.oracle.bmc.servicemesh.model.IngressGatewayHost;
import com.oracle.bmc.servicemesh.model.IngressGatewayMutualTransportLayerSecurityDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateIngressGatewayDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="hosts")
    private final List<IngressGatewayHost> hosts;
    @JsonProperty(value="accessLogging")
    private final AccessLoggingConfiguration accessLogging;
    @JsonProperty(value="mtls")
    private final IngressGatewayMutualTransportLayerSecurityDetails mtls;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"description", "hosts", "accessLogging", "mtls", "freeformTags", "definedTags"})
    public UpdateIngressGatewayDetails(String description, List<IngressGatewayHost> hosts, AccessLoggingConfiguration accessLogging, IngressGatewayMutualTransportLayerSecurityDetails mtls, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.description = description;
        this.hosts = hosts;
        this.accessLogging = accessLogging;
        this.mtls = mtls;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public List<IngressGatewayHost> getHosts() {
        return this.hosts;
    }

    public AccessLoggingConfiguration getAccessLogging() {
        return this.accessLogging;
    }

    public IngressGatewayMutualTransportLayerSecurityDetails getMtls() {
        return this.mtls;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateIngressGatewayDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", hosts=").append(String.valueOf(this.hosts));
        sb.append(", accessLogging=").append(String.valueOf((Object)this.accessLogging));
        sb.append(", mtls=").append(String.valueOf((Object)this.mtls));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateIngressGatewayDetails)) {
            return false;
        }
        UpdateIngressGatewayDetails other = (UpdateIngressGatewayDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.hosts, other.hosts) && Objects.equals((Object)this.accessLogging, (Object)other.accessLogging) && Objects.equals((Object)this.mtls, (Object)other.mtls) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.hosts == null ? 43 : this.hosts.hashCode());
        result = result * 59 + (this.accessLogging == null ? 43 : this.accessLogging.hashCode());
        result = result * 59 + (this.mtls == null ? 43 : this.mtls.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="hosts")
        private List<IngressGatewayHost> hosts;
        @JsonProperty(value="accessLogging")
        private AccessLoggingConfiguration accessLogging;
        @JsonProperty(value="mtls")
        private IngressGatewayMutualTransportLayerSecurityDetails mtls;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder hosts(List<IngressGatewayHost> hosts) {
            this.hosts = hosts;
            this.__explicitlySet__.add("hosts");
            return this;
        }

        public Builder accessLogging(AccessLoggingConfiguration accessLogging) {
            this.accessLogging = accessLogging;
            this.__explicitlySet__.add("accessLogging");
            return this;
        }

        public Builder mtls(IngressGatewayMutualTransportLayerSecurityDetails mtls) {
            this.mtls = mtls;
            this.__explicitlySet__.add("mtls");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateIngressGatewayDetails build() {
            UpdateIngressGatewayDetails model = new UpdateIngressGatewayDetails(this.description, this.hosts, this.accessLogging, this.mtls, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateIngressGatewayDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("hosts")) {
                this.hosts(model.getHosts());
            }
            if (model.wasPropertyExplicitlySet("accessLogging")) {
                this.accessLogging(model.getAccessLogging());
            }
            if (model.wasPropertyExplicitlySet("mtls")) {
                this.mtls(model.getMtls());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

