/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIngressGatewayRequest
extends BmcRequest<Void> {
    private String ingressGatewayId;
    private String opcRequestId;

    public String getIngressGatewayId() {
        return this.ingressGatewayId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().ingressGatewayId(this.ingressGatewayId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ingressGatewayId=").append(String.valueOf(this.ingressGatewayId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIngressGatewayRequest)) {
            return false;
        }
        GetIngressGatewayRequest other = (GetIngressGatewayRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ingressGatewayId, other.ingressGatewayId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ingressGatewayId == null ? 43 : this.ingressGatewayId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIngressGatewayRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ingressGatewayId = null;
        private String opcRequestId = null;

        public Builder ingressGatewayId(String ingressGatewayId) {
            this.ingressGatewayId = ingressGatewayId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIngressGatewayRequest o) {
            this.ingressGatewayId(o.getIngressGatewayId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIngressGatewayRequest build() {
            GetIngressGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIngressGatewayRequest buildWithoutInvocationCallback() {
            GetIngressGatewayRequest request = new GetIngressGatewayRequest();
            request.ingressGatewayId = this.ingressGatewayId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

