/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.servicemesh.ServiceMesh;
import com.oracle.bmc.servicemesh.ServiceMeshPaginators;
import com.oracle.bmc.servicemesh.ServiceMeshWaiters;
import com.oracle.bmc.servicemesh.model.AccessPolicy;
import com.oracle.bmc.servicemesh.model.AccessPolicyCollection;
import com.oracle.bmc.servicemesh.model.IngressGateway;
import com.oracle.bmc.servicemesh.model.IngressGatewayCollection;
import com.oracle.bmc.servicemesh.model.IngressGatewayRouteTable;
import com.oracle.bmc.servicemesh.model.IngressGatewayRouteTableCollection;
import com.oracle.bmc.servicemesh.model.Mesh;
import com.oracle.bmc.servicemesh.model.MeshCollection;
import com.oracle.bmc.servicemesh.model.ProxyDetails;
import com.oracle.bmc.servicemesh.model.VirtualDeployment;
import com.oracle.bmc.servicemesh.model.VirtualDeploymentCollection;
import com.oracle.bmc.servicemesh.model.VirtualService;
import com.oracle.bmc.servicemesh.model.VirtualServiceCollection;
import com.oracle.bmc.servicemesh.model.VirtualServiceRouteTable;
import com.oracle.bmc.servicemesh.model.VirtualServiceRouteTableCollection;
import com.oracle.bmc.servicemesh.model.WorkRequest;
import com.oracle.bmc.servicemesh.model.WorkRequestCollection;
import com.oracle.bmc.servicemesh.model.WorkRequestErrorCollection;
import com.oracle.bmc.servicemesh.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.servicemesh.requests.CancelWorkRequestRequest;
import com.oracle.bmc.servicemesh.requests.ChangeAccessPolicyCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeIngressGatewayCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeIngressGatewayRouteTableCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeMeshCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeVirtualDeploymentCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeVirtualServiceCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.ChangeVirtualServiceRouteTableCompartmentRequest;
import com.oracle.bmc.servicemesh.requests.CreateAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.CreateIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.CreateIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.CreateMeshRequest;
import com.oracle.bmc.servicemesh.requests.CreateVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.CreateVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.CreateVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.DeleteAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.DeleteIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.DeleteIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.DeleteMeshRequest;
import com.oracle.bmc.servicemesh.requests.DeleteVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.DeleteVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.DeleteVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.GetIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.GetIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetMeshRequest;
import com.oracle.bmc.servicemesh.requests.GetProxyDetailsRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetWorkRequestRequest;
import com.oracle.bmc.servicemesh.requests.ListAccessPoliciesRequest;
import com.oracle.bmc.servicemesh.requests.ListIngressGatewayRouteTablesRequest;
import com.oracle.bmc.servicemesh.requests.ListIngressGatewaysRequest;
import com.oracle.bmc.servicemesh.requests.ListMeshesRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualDeploymentsRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualServiceRouteTablesRequest;
import com.oracle.bmc.servicemesh.requests.ListVirtualServicesRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.servicemesh.requests.ListWorkRequestsRequest;
import com.oracle.bmc.servicemesh.requests.UpdateAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.UpdateIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.UpdateIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.UpdateMeshRequest;
import com.oracle.bmc.servicemesh.requests.UpdateVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.UpdateVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.UpdateVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.responses.CancelWorkRequestResponse;
import com.oracle.bmc.servicemesh.responses.ChangeAccessPolicyCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeIngressGatewayCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeIngressGatewayRouteTableCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeMeshCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeVirtualDeploymentCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeVirtualServiceCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.ChangeVirtualServiceRouteTableCompartmentResponse;
import com.oracle.bmc.servicemesh.responses.CreateAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.CreateIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.CreateIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.CreateMeshResponse;
import com.oracle.bmc.servicemesh.responses.CreateVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.CreateVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.CreateVirtualServiceRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.DeleteAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.DeleteIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.DeleteIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.DeleteMeshResponse;
import com.oracle.bmc.servicemesh.responses.DeleteVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.DeleteVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.DeleteVirtualServiceRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.GetIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.GetIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetMeshResponse;
import com.oracle.bmc.servicemesh.responses.GetProxyDetailsResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualServiceRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetWorkRequestResponse;
import com.oracle.bmc.servicemesh.responses.ListAccessPoliciesResponse;
import com.oracle.bmc.servicemesh.responses.ListIngressGatewayRouteTablesResponse;
import com.oracle.bmc.servicemesh.responses.ListIngressGatewaysResponse;
import com.oracle.bmc.servicemesh.responses.ListMeshesResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualDeploymentsResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualServiceRouteTablesResponse;
import com.oracle.bmc.servicemesh.responses.ListVirtualServicesResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.servicemesh.responses.ListWorkRequestsResponse;
import com.oracle.bmc.servicemesh.responses.UpdateAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.UpdateIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.UpdateIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.UpdateMeshResponse;
import com.oracle.bmc.servicemesh.responses.UpdateVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.UpdateVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.UpdateVirtualServiceRouteTableResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMeshClient
extends BaseSyncClient
implements ServiceMesh {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SERVICEMESH").serviceEndpointPrefix("").serviceEndpointTemplate("https://servicemesh.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMeshClient.class);
    private final ServiceMeshWaiters waiters;
    private final ServiceMeshPaginators paginators;

    ServiceMeshClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ServiceMesh-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ServiceMeshWaiters(executorService, this);
        this.paginators = new ServiceMeshPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("ServiceMesh", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeAccessPolicyCompartmentResponse changeAccessPolicyCompartment(ChangeAccessPolicyCompartmentRequest request) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAccessPolicyCompartmentDetails(), "changeAccessPolicyCompartmentDetails is required");
        return (ChangeAccessPolicyCompartmentResponse)this.clientCall(request, ChangeAccessPolicyCompartmentResponse::builder).logger(LOG, "changeAccessPolicyCompartment").serviceDetails("ServiceMesh", "ChangeAccessPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/ChangeAccessPolicyCompartment").method(Method.POST).requestBuilder(ChangeAccessPolicyCompartmentRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeAccessPolicyCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeAccessPolicyCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeIngressGatewayCompartmentResponse changeIngressGatewayCompartment(ChangeIngressGatewayCompartmentRequest request) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIngressGatewayCompartmentDetails(), "changeIngressGatewayCompartmentDetails is required");
        return (ChangeIngressGatewayCompartmentResponse)this.clientCall(request, ChangeIngressGatewayCompartmentResponse::builder).logger(LOG, "changeIngressGatewayCompartment").serviceDetails("ServiceMesh", "ChangeIngressGatewayCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/ChangeIngressGatewayCompartment").method(Method.POST).requestBuilder(ChangeIngressGatewayCompartmentRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIngressGatewayCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIngressGatewayCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeIngressGatewayRouteTableCompartmentResponse changeIngressGatewayRouteTableCompartment(ChangeIngressGatewayRouteTableCompartmentRequest request) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIngressGatewayRouteTableCompartmentDetails(), "changeIngressGatewayRouteTableCompartmentDetails is required");
        return (ChangeIngressGatewayRouteTableCompartmentResponse)this.clientCall(request, ChangeIngressGatewayRouteTableCompartmentResponse::builder).logger(LOG, "changeIngressGatewayRouteTableCompartment").serviceDetails("ServiceMesh", "ChangeIngressGatewayRouteTableCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/ChangeIngressGatewayRouteTableCompartment").method(Method.POST).requestBuilder(ChangeIngressGatewayRouteTableCompartmentRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIngressGatewayRouteTableCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIngressGatewayRouteTableCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeMeshCompartmentResponse changeMeshCompartment(ChangeMeshCompartmentRequest request) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeMeshCompartmentDetails(), "changeMeshCompartmentDetails is required");
        return (ChangeMeshCompartmentResponse)this.clientCall(request, ChangeMeshCompartmentResponse::builder).logger(LOG, "changeMeshCompartment").serviceDetails("ServiceMesh", "ChangeMeshCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/ChangeMeshCompartment").method(Method.POST).requestBuilder(ChangeMeshCompartmentRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMeshCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMeshCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVirtualDeploymentCompartmentResponse changeVirtualDeploymentCompartment(ChangeVirtualDeploymentCompartmentRequest request) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVirtualDeploymentCompartmentDetails(), "changeVirtualDeploymentCompartmentDetails is required");
        return (ChangeVirtualDeploymentCompartmentResponse)this.clientCall(request, ChangeVirtualDeploymentCompartmentResponse::builder).logger(LOG, "changeVirtualDeploymentCompartment").serviceDetails("ServiceMesh", "ChangeVirtualDeploymentCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/ChangeVirtualDeploymentCompartment").method(Method.POST).requestBuilder(ChangeVirtualDeploymentCompartmentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVirtualDeploymentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVirtualDeploymentCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVirtualServiceCompartmentResponse changeVirtualServiceCompartment(ChangeVirtualServiceCompartmentRequest request) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVirtualServiceCompartmentDetails(), "changeVirtualServiceCompartmentDetails is required");
        return (ChangeVirtualServiceCompartmentResponse)this.clientCall(request, ChangeVirtualServiceCompartmentResponse::builder).logger(LOG, "changeVirtualServiceCompartment").serviceDetails("ServiceMesh", "ChangeVirtualServiceCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/ChangeVirtualServiceCompartment").method(Method.POST).requestBuilder(ChangeVirtualServiceCompartmentRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVirtualServiceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVirtualServiceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVirtualServiceRouteTableCompartmentResponse changeVirtualServiceRouteTableCompartment(ChangeVirtualServiceRouteTableCompartmentRequest request) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVirtualServiceRouteTableCompartmentDetails(), "changeVirtualServiceRouteTableCompartmentDetails is required");
        return (ChangeVirtualServiceRouteTableCompartmentResponse)this.clientCall(request, ChangeVirtualServiceRouteTableCompartmentResponse::builder).logger(LOG, "changeVirtualServiceRouteTableCompartment").serviceDetails("ServiceMesh", "ChangeVirtualServiceRouteTableCompartment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/ChangeVirtualServiceRouteTableCompartment").method(Method.POST).requestBuilder(ChangeVirtualServiceRouteTableCompartmentRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVirtualServiceRouteTableCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVirtualServiceRouteTableCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAccessPolicyResponse createAccessPolicy(CreateAccessPolicyRequest request) {
        Objects.requireNonNull(request.getCreateAccessPolicyDetails(), "createAccessPolicyDetails is required");
        return (CreateAccessPolicyResponse)this.clientCall(request, CreateAccessPolicyResponse::builder).logger(LOG, "createAccessPolicy").serviceDetails("ServiceMesh", "CreateAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/CreateAccessPolicy").method(Method.POST).requestBuilder(CreateAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(AccessPolicy.class, CreateAccessPolicyResponse.Builder::accessPolicy).handleResponseHeaderString("etag", CreateAccessPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateAccessPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateAccessPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateAccessPolicyResponse.Builder::location).callSync();
    }

    @Override
    public CreateIngressGatewayResponse createIngressGateway(CreateIngressGatewayRequest request) {
        Objects.requireNonNull(request.getCreateIngressGatewayDetails(), "createIngressGatewayDetails is required");
        return (CreateIngressGatewayResponse)this.clientCall(request, CreateIngressGatewayResponse::builder).logger(LOG, "createIngressGateway").serviceDetails("ServiceMesh", "CreateIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/CreateIngressGateway").method(Method.POST).requestBuilder(CreateIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(IngressGateway.class, CreateIngressGatewayResponse.Builder::ingressGateway).handleResponseHeaderString("etag", CreateIngressGatewayResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateIngressGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateIngressGatewayResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateIngressGatewayResponse.Builder::location).callSync();
    }

    @Override
    public CreateIngressGatewayRouteTableResponse createIngressGatewayRouteTable(CreateIngressGatewayRouteTableRequest request) {
        Objects.requireNonNull(request.getCreateIngressGatewayRouteTableDetails(), "createIngressGatewayRouteTableDetails is required");
        return (CreateIngressGatewayRouteTableResponse)this.clientCall(request, CreateIngressGatewayRouteTableResponse::builder).logger(LOG, "createIngressGatewayRouteTable").serviceDetails("ServiceMesh", "CreateIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/CreateIngressGatewayRouteTable").method(Method.POST).requestBuilder(CreateIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(IngressGatewayRouteTable.class, CreateIngressGatewayRouteTableResponse.Builder::ingressGatewayRouteTable).handleResponseHeaderString("etag", CreateIngressGatewayRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateIngressGatewayRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateIngressGatewayRouteTableResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateIngressGatewayRouteTableResponse.Builder::location).callSync();
    }

    @Override
    public CreateMeshResponse createMesh(CreateMeshRequest request) {
        Objects.requireNonNull(request.getCreateMeshDetails(), "createMeshDetails is required");
        return (CreateMeshResponse)this.clientCall(request, CreateMeshResponse::builder).logger(LOG, "createMesh").serviceDetails("ServiceMesh", "CreateMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/CreateMesh").method(Method.POST).requestBuilder(CreateMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Mesh.class, CreateMeshResponse.Builder::mesh).handleResponseHeaderString("etag", CreateMeshResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateMeshResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateMeshResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateMeshResponse.Builder::location).callSync();
    }

    @Override
    public CreateVirtualDeploymentResponse createVirtualDeployment(CreateVirtualDeploymentRequest request) {
        Objects.requireNonNull(request.getCreateVirtualDeploymentDetails(), "createVirtualDeploymentDetails is required");
        return (CreateVirtualDeploymentResponse)this.clientCall(request, CreateVirtualDeploymentResponse::builder).logger(LOG, "createVirtualDeployment").serviceDetails("ServiceMesh", "CreateVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/CreateVirtualDeployment").method(Method.POST).requestBuilder(CreateVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(VirtualDeployment.class, CreateVirtualDeploymentResponse.Builder::virtualDeployment).handleResponseHeaderString("etag", CreateVirtualDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateVirtualDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualDeploymentResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateVirtualDeploymentResponse.Builder::location).callSync();
    }

    @Override
    public CreateVirtualServiceResponse createVirtualService(CreateVirtualServiceRequest request) {
        Objects.requireNonNull(request.getCreateVirtualServiceDetails(), "createVirtualServiceDetails is required");
        return (CreateVirtualServiceResponse)this.clientCall(request, CreateVirtualServiceResponse::builder).logger(LOG, "createVirtualService").serviceDetails("ServiceMesh", "CreateVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/CreateVirtualService").method(Method.POST).requestBuilder(CreateVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(VirtualService.class, CreateVirtualServiceResponse.Builder::virtualService).handleResponseHeaderString("etag", CreateVirtualServiceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateVirtualServiceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualServiceResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateVirtualServiceResponse.Builder::location).callSync();
    }

    @Override
    public CreateVirtualServiceRouteTableResponse createVirtualServiceRouteTable(CreateVirtualServiceRouteTableRequest request) {
        Objects.requireNonNull(request.getCreateVirtualServiceRouteTableDetails(), "createVirtualServiceRouteTableDetails is required");
        return (CreateVirtualServiceRouteTableResponse)this.clientCall(request, CreateVirtualServiceRouteTableResponse::builder).logger(LOG, "createVirtualServiceRouteTable").serviceDetails("ServiceMesh", "CreateVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/CreateVirtualServiceRouteTable").method(Method.POST).requestBuilder(CreateVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(VirtualServiceRouteTable.class, CreateVirtualServiceRouteTableResponse.Builder::virtualServiceRouteTable).handleResponseHeaderString("etag", CreateVirtualServiceRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateVirtualServiceRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualServiceRouteTableResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateVirtualServiceRouteTableResponse.Builder::location).callSync();
    }

    @Override
    public DeleteAccessPolicyResponse deleteAccessPolicy(DeleteAccessPolicyRequest request) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteAccessPolicyResponse)this.clientCall(request, DeleteAccessPolicyResponse::builder).logger(LOG, "deleteAccessPolicy").serviceDetails("ServiceMesh", "DeleteAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/DeleteAccessPolicy").method(Method.DELETE).requestBuilder(DeleteAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteAccessPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteAccessPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteIngressGatewayResponse deleteIngressGateway(DeleteIngressGatewayRequest request) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        return (DeleteIngressGatewayResponse)this.clientCall(request, DeleteIngressGatewayResponse::builder).logger(LOG, "deleteIngressGateway").serviceDetails("ServiceMesh", "DeleteIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/DeleteIngressGateway").method(Method.DELETE).requestBuilder(DeleteIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteIngressGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteIngressGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteIngressGatewayRouteTableResponse deleteIngressGatewayRouteTable(DeleteIngressGatewayRouteTableRequest request) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        return (DeleteIngressGatewayRouteTableResponse)this.clientCall(request, DeleteIngressGatewayRouteTableResponse::builder).logger(LOG, "deleteIngressGatewayRouteTable").serviceDetails("ServiceMesh", "DeleteIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/DeleteIngressGatewayRouteTable").method(Method.DELETE).requestBuilder(DeleteIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteIngressGatewayRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteIngressGatewayRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteMeshResponse deleteMesh(DeleteMeshRequest request) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        return (DeleteMeshResponse)this.clientCall(request, DeleteMeshResponse::builder).logger(LOG, "deleteMesh").serviceDetails("ServiceMesh", "DeleteMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/DeleteMesh").method(Method.DELETE).requestBuilder(DeleteMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteMeshResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMeshResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVirtualDeploymentResponse deleteVirtualDeployment(DeleteVirtualDeploymentRequest request) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        return (DeleteVirtualDeploymentResponse)this.clientCall(request, DeleteVirtualDeploymentResponse::builder).logger(LOG, "deleteVirtualDeployment").serviceDetails("ServiceMesh", "DeleteVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/DeleteVirtualDeployment").method(Method.DELETE).requestBuilder(DeleteVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteVirtualDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVirtualServiceResponse deleteVirtualService(DeleteVirtualServiceRequest request) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        return (DeleteVirtualServiceResponse)this.clientCall(request, DeleteVirtualServiceResponse::builder).logger(LOG, "deleteVirtualService").serviceDetails("ServiceMesh", "DeleteVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/DeleteVirtualService").method(Method.DELETE).requestBuilder(DeleteVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteVirtualServiceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualServiceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVirtualServiceRouteTableResponse deleteVirtualServiceRouteTable(DeleteVirtualServiceRouteTableRequest request) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        return (DeleteVirtualServiceRouteTableResponse)this.clientCall(request, DeleteVirtualServiceRouteTableResponse::builder).logger(LOG, "deleteVirtualServiceRouteTable").serviceDetails("ServiceMesh", "DeleteVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/DeleteVirtualServiceRouteTable").method(Method.DELETE).requestBuilder(DeleteVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteVirtualServiceRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualServiceRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAccessPolicyResponse getAccessPolicy(GetAccessPolicyRequest request) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        return (GetAccessPolicyResponse)this.clientCall(request, GetAccessPolicyResponse::builder).logger(LOG, "getAccessPolicy").serviceDetails("ServiceMesh", "GetAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/GetAccessPolicy").method(Method.GET).requestBuilder(GetAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AccessPolicy.class, GetAccessPolicyResponse.Builder::accessPolicy).handleResponseHeaderString("etag", GetAccessPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAccessPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIngressGatewayResponse getIngressGateway(GetIngressGatewayRequest request) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        return (GetIngressGatewayResponse)this.clientCall(request, GetIngressGatewayResponse::builder).logger(LOG, "getIngressGateway").serviceDetails("ServiceMesh", "GetIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/GetIngressGateway").method(Method.GET).requestBuilder(GetIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(IngressGateway.class, GetIngressGatewayResponse.Builder::ingressGateway).handleResponseHeaderString("etag", GetIngressGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIngressGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIngressGatewayRouteTableResponse getIngressGatewayRouteTable(GetIngressGatewayRouteTableRequest request) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        return (GetIngressGatewayRouteTableResponse)this.clientCall(request, GetIngressGatewayRouteTableResponse::builder).logger(LOG, "getIngressGatewayRouteTable").serviceDetails("ServiceMesh", "GetIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/GetIngressGatewayRouteTable").method(Method.GET).requestBuilder(GetIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(IngressGatewayRouteTable.class, GetIngressGatewayRouteTableResponse.Builder::ingressGatewayRouteTable).handleResponseHeaderString("etag", GetIngressGatewayRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIngressGatewayRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetMeshResponse getMesh(GetMeshRequest request) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        return (GetMeshResponse)this.clientCall(request, GetMeshResponse::builder).logger(LOG, "getMesh").serviceDetails("ServiceMesh", "GetMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/GetMesh").method(Method.GET).requestBuilder(GetMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Mesh.class, GetMeshResponse.Builder::mesh).handleResponseHeaderString("etag", GetMeshResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMeshResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetProxyDetailsResponse getProxyDetails(GetProxyDetailsRequest request) {
        return (GetProxyDetailsResponse)this.clientCall(request, GetProxyDetailsResponse::builder).logger(LOG, "getProxyDetails").serviceDetails("ServiceMesh", "GetProxyDetails", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/ProxyDetails/GetProxyDetails").method(Method.GET).requestBuilder(GetProxyDetailsRequest::builder).basePath("/20220615").appendPathParam("proxyDetails").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProxyDetails.class, GetProxyDetailsResponse.Builder::proxyDetails).handleResponseHeaderString("opc-request-id", GetProxyDetailsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVirtualDeploymentResponse getVirtualDeployment(GetVirtualDeploymentRequest request) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        return (GetVirtualDeploymentResponse)this.clientCall(request, GetVirtualDeploymentResponse::builder).logger(LOG, "getVirtualDeployment").serviceDetails("ServiceMesh", "GetVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/GetVirtualDeployment").method(Method.GET).requestBuilder(GetVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VirtualDeployment.class, GetVirtualDeploymentResponse.Builder::virtualDeployment).handleResponseHeaderString("etag", GetVirtualDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVirtualServiceResponse getVirtualService(GetVirtualServiceRequest request) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        return (GetVirtualServiceResponse)this.clientCall(request, GetVirtualServiceResponse::builder).logger(LOG, "getVirtualService").serviceDetails("ServiceMesh", "GetVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/GetVirtualService").method(Method.GET).requestBuilder(GetVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VirtualService.class, GetVirtualServiceResponse.Builder::virtualService).handleResponseHeaderString("etag", GetVirtualServiceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualServiceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVirtualServiceRouteTableResponse getVirtualServiceRouteTable(GetVirtualServiceRouteTableRequest request) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        return (GetVirtualServiceRouteTableResponse)this.clientCall(request, GetVirtualServiceRouteTableResponse::builder).logger(LOG, "getVirtualServiceRouteTable").serviceDetails("ServiceMesh", "GetVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/GetVirtualServiceRouteTable").method(Method.GET).requestBuilder(GetVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VirtualServiceRouteTable.class, GetVirtualServiceRouteTableResponse.Builder::virtualServiceRouteTable).handleResponseHeaderString("etag", GetVirtualServiceRouteTableResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualServiceRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ServiceMesh", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListAccessPoliciesResponse listAccessPolicies(ListAccessPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAccessPoliciesResponse)this.clientCall(request, ListAccessPoliciesResponse::builder).logger(LOG, "listAccessPolicies").serviceDetails("ServiceMesh", "ListAccessPolicies", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/ListAccessPolicies").method(Method.GET).requestBuilder(ListAccessPoliciesRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("meshId", (Object)request.getMeshId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AccessPolicyCollection.class, ListAccessPoliciesResponse.Builder::accessPolicyCollection).handleResponseHeaderString("opc-request-id", ListAccessPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAccessPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListIngressGatewayRouteTablesResponse listIngressGatewayRouteTables(ListIngressGatewayRouteTablesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListIngressGatewayRouteTablesResponse)this.clientCall(request, ListIngressGatewayRouteTablesResponse::builder).logger(LOG, "listIngressGatewayRouteTables").serviceDetails("ServiceMesh", "ListIngressGatewayRouteTables", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/ListIngressGatewayRouteTables").method(Method.GET).requestBuilder(ListIngressGatewayRouteTablesRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("ingressGatewayId", (Object)request.getIngressGatewayId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(IngressGatewayRouteTableCollection.class, ListIngressGatewayRouteTablesResponse.Builder::ingressGatewayRouteTableCollection).handleResponseHeaderString("opc-request-id", ListIngressGatewayRouteTablesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIngressGatewayRouteTablesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListIngressGatewaysResponse listIngressGateways(ListIngressGatewaysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListIngressGatewaysResponse)this.clientCall(request, ListIngressGatewaysResponse::builder).logger(LOG, "listIngressGateways").serviceDetails("ServiceMesh", "ListIngressGateways", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/ListIngressGateways").method(Method.GET).requestBuilder(ListIngressGatewaysRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("meshId", (Object)request.getMeshId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(IngressGatewayCollection.class, ListIngressGatewaysResponse.Builder::ingressGatewayCollection).handleResponseHeaderString("opc-request-id", ListIngressGatewaysResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIngressGatewaysResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListMeshesResponse listMeshes(ListMeshesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListMeshesResponse)this.clientCall(request, ListMeshesResponse::builder).logger(LOG, "listMeshes").serviceDetails("ServiceMesh", "ListMeshes", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/ListMeshes").method(Method.GET).requestBuilder(ListMeshesRequest::builder).basePath("/20220615").appendPathParam("meshes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(MeshCollection.class, ListMeshesResponse.Builder::meshCollection).handleResponseHeaderString("opc-request-id", ListMeshesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMeshesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVirtualDeploymentsResponse listVirtualDeployments(ListVirtualDeploymentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVirtualDeploymentsResponse)this.clientCall(request, ListVirtualDeploymentsResponse::builder).logger(LOG, "listVirtualDeployments").serviceDetails("ServiceMesh", "ListVirtualDeployments", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/ListVirtualDeployments").method(Method.GET).requestBuilder(ListVirtualDeploymentsRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("virtualServiceId", (Object)request.getVirtualServiceId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VirtualDeploymentCollection.class, ListVirtualDeploymentsResponse.Builder::virtualDeploymentCollection).handleResponseHeaderString("opc-request-id", ListVirtualDeploymentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVirtualDeploymentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVirtualServiceRouteTablesResponse listVirtualServiceRouteTables(ListVirtualServiceRouteTablesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVirtualServiceRouteTablesResponse)this.clientCall(request, ListVirtualServiceRouteTablesResponse::builder).logger(LOG, "listVirtualServiceRouteTables").serviceDetails("ServiceMesh", "ListVirtualServiceRouteTables", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/ListVirtualServiceRouteTables").method(Method.GET).requestBuilder(ListVirtualServiceRouteTablesRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("virtualServiceId", (Object)request.getVirtualServiceId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VirtualServiceRouteTableCollection.class, ListVirtualServiceRouteTablesResponse.Builder::virtualServiceRouteTableCollection).handleResponseHeaderString("opc-request-id", ListVirtualServiceRouteTablesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVirtualServiceRouteTablesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVirtualServicesResponse listVirtualServices(ListVirtualServicesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVirtualServicesResponse)this.clientCall(request, ListVirtualServicesResponse::builder).logger(LOG, "listVirtualServices").serviceDetails("ServiceMesh", "ListVirtualServices", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/ListVirtualServices").method(Method.GET).requestBuilder(ListVirtualServicesRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("meshId", (Object)request.getMeshId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VirtualServiceCollection.class, ListVirtualServicesResponse.Builder::virtualServiceCollection).handleResponseHeaderString("opc-request-id", ListVirtualServicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVirtualServicesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ServiceMesh", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ServiceMesh", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ServiceMesh", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220615").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("operationStatus", (BmcEnum)request.getOperationStatus()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateAccessPolicyResponse updateAccessPolicy(UpdateAccessPolicyRequest request) {
        Validate.notBlank((String)request.getAccessPolicyId(), (String)"accessPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAccessPolicyDetails(), "updateAccessPolicyDetails is required");
        return (UpdateAccessPolicyResponse)this.clientCall(request, UpdateAccessPolicyResponse::builder).logger(LOG, "updateAccessPolicy").serviceDetails("ServiceMesh", "UpdateAccessPolicy", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/AccessPolicy/UpdateAccessPolicy").method(Method.PUT).requestBuilder(UpdateAccessPolicyRequest::builder).basePath("/20220615").appendPathParam("accessPolicies").appendPathParam(request.getAccessPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAccessPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAccessPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateIngressGatewayResponse updateIngressGateway(UpdateIngressGatewayRequest request) {
        Validate.notBlank((String)request.getIngressGatewayId(), (String)"ingressGatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIngressGatewayDetails(), "updateIngressGatewayDetails is required");
        return (UpdateIngressGatewayResponse)this.clientCall(request, UpdateIngressGatewayResponse::builder).logger(LOG, "updateIngressGateway").serviceDetails("ServiceMesh", "UpdateIngressGateway", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGateway/UpdateIngressGateway").method(Method.PUT).requestBuilder(UpdateIngressGatewayRequest::builder).basePath("/20220615").appendPathParam("ingressGateways").appendPathParam(request.getIngressGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateIngressGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateIngressGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateIngressGatewayRouteTableResponse updateIngressGatewayRouteTable(UpdateIngressGatewayRouteTableRequest request) {
        Validate.notBlank((String)request.getIngressGatewayRouteTableId(), (String)"ingressGatewayRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIngressGatewayRouteTableDetails(), "updateIngressGatewayRouteTableDetails is required");
        return (UpdateIngressGatewayRouteTableResponse)this.clientCall(request, UpdateIngressGatewayRouteTableResponse::builder).logger(LOG, "updateIngressGatewayRouteTable").serviceDetails("ServiceMesh", "UpdateIngressGatewayRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/IngressGatewayRouteTable/UpdateIngressGatewayRouteTable").method(Method.PUT).requestBuilder(UpdateIngressGatewayRouteTableRequest::builder).basePath("/20220615").appendPathParam("ingressGatewayRouteTables").appendPathParam(request.getIngressGatewayRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateIngressGatewayRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateIngressGatewayRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateMeshResponse updateMesh(UpdateMeshRequest request) {
        Validate.notBlank((String)request.getMeshId(), (String)"meshId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMeshDetails(), "updateMeshDetails is required");
        return (UpdateMeshResponse)this.clientCall(request, UpdateMeshResponse::builder).logger(LOG, "updateMesh").serviceDetails("ServiceMesh", "UpdateMesh", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/Mesh/UpdateMesh").method(Method.PUT).requestBuilder(UpdateMeshRequest::builder).basePath("/20220615").appendPathParam("meshes").appendPathParam(request.getMeshId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateMeshResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateMeshResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVirtualDeploymentResponse updateVirtualDeployment(UpdateVirtualDeploymentRequest request) {
        Validate.notBlank((String)request.getVirtualDeploymentId(), (String)"virtualDeploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualDeploymentDetails(), "updateVirtualDeploymentDetails is required");
        return (UpdateVirtualDeploymentResponse)this.clientCall(request, UpdateVirtualDeploymentResponse::builder).logger(LOG, "updateVirtualDeployment").serviceDetails("ServiceMesh", "UpdateVirtualDeployment", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualDeployment/UpdateVirtualDeployment").method(Method.PUT).requestBuilder(UpdateVirtualDeploymentRequest::builder).basePath("/20220615").appendPathParam("virtualDeployments").appendPathParam(request.getVirtualDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVirtualServiceResponse updateVirtualService(UpdateVirtualServiceRequest request) {
        Validate.notBlank((String)request.getVirtualServiceId(), (String)"virtualServiceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualServiceDetails(), "updateVirtualServiceDetails is required");
        return (UpdateVirtualServiceResponse)this.clientCall(request, UpdateVirtualServiceResponse::builder).logger(LOG, "updateVirtualService").serviceDetails("ServiceMesh", "UpdateVirtualService", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualService/UpdateVirtualService").method(Method.PUT).requestBuilder(UpdateVirtualServiceRequest::builder).basePath("/20220615").appendPathParam("virtualServices").appendPathParam(request.getVirtualServiceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualServiceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualServiceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVirtualServiceRouteTableResponse updateVirtualServiceRouteTable(UpdateVirtualServiceRouteTableRequest request) {
        Validate.notBlank((String)request.getVirtualServiceRouteTableId(), (String)"virtualServiceRouteTableId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualServiceRouteTableDetails(), "updateVirtualServiceRouteTableDetails is required");
        return (UpdateVirtualServiceRouteTableResponse)this.clientCall(request, UpdateVirtualServiceRouteTableResponse::builder).logger(LOG, "updateVirtualServiceRouteTable").serviceDetails("ServiceMesh", "UpdateVirtualServiceRouteTable", "https://docs.oracle.com/iaas/api/#/en/service-mesh/20220615/VirtualServiceRouteTable/UpdateVirtualServiceRouteTable").method(Method.PUT).requestBuilder(UpdateVirtualServiceRouteTableRequest::builder).basePath("/20220615").appendPathParam("virtualServiceRouteTables").appendPathParam(request.getVirtualServiceRouteTableId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualServiceRouteTableResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualServiceRouteTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ServiceMeshWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ServiceMeshPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ServiceMeshClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ServiceMeshClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceMeshClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ServiceMeshClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceMeshClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ServiceMeshClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceMeshClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ServiceMeshClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceMeshClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ServiceMeshClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceMeshClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ServiceMeshClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceMeshClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceMeshClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ServiceMeshClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ServiceMeshClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ServiceMeshClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "servicemesh";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"servicemesh");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ServiceMeshClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ServiceMeshClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

