/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh;

import com.oracle.bmc.servicemesh.ServiceMesh;
import com.oracle.bmc.servicemesh.model.AccessPolicy;
import com.oracle.bmc.servicemesh.model.IngressGateway;
import com.oracle.bmc.servicemesh.model.IngressGatewayRouteTable;
import com.oracle.bmc.servicemesh.model.Mesh;
import com.oracle.bmc.servicemesh.model.VirtualDeployment;
import com.oracle.bmc.servicemesh.model.VirtualService;
import com.oracle.bmc.servicemesh.model.VirtualServiceRouteTable;
import com.oracle.bmc.servicemesh.requests.GetAccessPolicyRequest;
import com.oracle.bmc.servicemesh.requests.GetIngressGatewayRequest;
import com.oracle.bmc.servicemesh.requests.GetIngressGatewayRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetMeshRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualDeploymentRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualServiceRequest;
import com.oracle.bmc.servicemesh.requests.GetVirtualServiceRouteTableRequest;
import com.oracle.bmc.servicemesh.requests.GetWorkRequestRequest;
import com.oracle.bmc.servicemesh.responses.GetAccessPolicyResponse;
import com.oracle.bmc.servicemesh.responses.GetIngressGatewayResponse;
import com.oracle.bmc.servicemesh.responses.GetIngressGatewayRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetMeshResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualDeploymentResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualServiceResponse;
import com.oracle.bmc.servicemesh.responses.GetVirtualServiceRouteTableResponse;
import com.oracle.bmc.servicemesh.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ServiceMeshWaiters {
    private final ExecutorService executorService;
    private final ServiceMesh client;

    public ServiceMeshWaiters(ExecutorService executorService, ServiceMesh client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAccessPolicyRequest, GetAccessPolicyResponse> forAccessPolicy(GetAccessPolicyRequest request, AccessPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAccessPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAccessPolicyRequest, GetAccessPolicyResponse> forAccessPolicy(GetAccessPolicyRequest request, AccessPolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAccessPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAccessPolicyRequest, GetAccessPolicyResponse> forAccessPolicy(GetAccessPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AccessPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAccessPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAccessPolicyRequest, GetAccessPolicyResponse> forAccessPolicy(BmcGenericWaiter waiter, GetAccessPolicyRequest request, AccessPolicy.LifecycleState ... targetStates) {
        final HashSet<AccessPolicy.LifecycleState> targetStatesSet = new HashSet<AccessPolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAccessPolicyRequest, GetAccessPolicyResponse>(){

            @Override
            public GetAccessPolicyResponse apply(GetAccessPolicyRequest request) {
                return ServiceMeshWaiters.this.client.getAccessPolicy(request);
            }
        }, (Predicate)new Predicate<GetAccessPolicyResponse>(){

            @Override
            public boolean test(GetAccessPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getAccessPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AccessPolicy.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetIngressGatewayRequest, GetIngressGatewayResponse> forIngressGateway(GetIngressGatewayRequest request, IngressGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIngressGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIngressGatewayRequest, GetIngressGatewayResponse> forIngressGateway(GetIngressGatewayRequest request, IngressGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIngressGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIngressGatewayRequest, GetIngressGatewayResponse> forIngressGateway(GetIngressGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IngressGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIngressGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIngressGatewayRequest, GetIngressGatewayResponse> forIngressGateway(BmcGenericWaiter waiter, GetIngressGatewayRequest request, IngressGateway.LifecycleState ... targetStates) {
        final HashSet<IngressGateway.LifecycleState> targetStatesSet = new HashSet<IngressGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIngressGatewayRequest, GetIngressGatewayResponse>(){

            @Override
            public GetIngressGatewayResponse apply(GetIngressGatewayRequest request) {
                return ServiceMeshWaiters.this.client.getIngressGateway(request);
            }
        }, (Predicate)new Predicate<GetIngressGatewayResponse>(){

            @Override
            public boolean test(GetIngressGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getIngressGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IngressGateway.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetIngressGatewayRouteTableRequest, GetIngressGatewayRouteTableResponse> forIngressGatewayRouteTable(GetIngressGatewayRouteTableRequest request, IngressGatewayRouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIngressGatewayRouteTable(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIngressGatewayRouteTableRequest, GetIngressGatewayRouteTableResponse> forIngressGatewayRouteTable(GetIngressGatewayRouteTableRequest request, IngressGatewayRouteTable.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIngressGatewayRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIngressGatewayRouteTableRequest, GetIngressGatewayRouteTableResponse> forIngressGatewayRouteTable(GetIngressGatewayRouteTableRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IngressGatewayRouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIngressGatewayRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIngressGatewayRouteTableRequest, GetIngressGatewayRouteTableResponse> forIngressGatewayRouteTable(BmcGenericWaiter waiter, GetIngressGatewayRouteTableRequest request, IngressGatewayRouteTable.LifecycleState ... targetStates) {
        final HashSet<IngressGatewayRouteTable.LifecycleState> targetStatesSet = new HashSet<IngressGatewayRouteTable.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIngressGatewayRouteTableRequest, GetIngressGatewayRouteTableResponse>(){

            @Override
            public GetIngressGatewayRouteTableResponse apply(GetIngressGatewayRouteTableRequest request) {
                return ServiceMeshWaiters.this.client.getIngressGatewayRouteTable(request);
            }
        }, (Predicate)new Predicate<GetIngressGatewayRouteTableResponse>(){

            @Override
            public boolean test(GetIngressGatewayRouteTableResponse response) {
                return targetStatesSet.contains((Object)response.getIngressGatewayRouteTable().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IngressGatewayRouteTable.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetMeshRequest, GetMeshResponse> forMesh(GetMeshRequest request, Mesh.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMesh(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMeshRequest, GetMeshResponse> forMesh(GetMeshRequest request, Mesh.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMesh(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetMeshRequest, GetMeshResponse> forMesh(GetMeshRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Mesh.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMesh(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetMeshRequest, GetMeshResponse> forMesh(BmcGenericWaiter waiter, GetMeshRequest request, Mesh.LifecycleState ... targetStates) {
        final HashSet<Mesh.LifecycleState> targetStatesSet = new HashSet<Mesh.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetMeshRequest, GetMeshResponse>(){

            @Override
            public GetMeshResponse apply(GetMeshRequest request) {
                return ServiceMeshWaiters.this.client.getMesh(request);
            }
        }, (Predicate)new Predicate<GetMeshResponse>(){

            @Override
            public boolean test(GetMeshResponse response) {
                return targetStatesSet.contains((Object)response.getMesh().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Mesh.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVirtualDeploymentRequest, GetVirtualDeploymentResponse> forVirtualDeployment(GetVirtualDeploymentRequest request, VirtualDeployment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualDeployment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVirtualDeploymentRequest, GetVirtualDeploymentResponse> forVirtualDeployment(GetVirtualDeploymentRequest request, VirtualDeployment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVirtualDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVirtualDeploymentRequest, GetVirtualDeploymentResponse> forVirtualDeployment(GetVirtualDeploymentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VirtualDeployment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVirtualDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVirtualDeploymentRequest, GetVirtualDeploymentResponse> forVirtualDeployment(BmcGenericWaiter waiter, GetVirtualDeploymentRequest request, VirtualDeployment.LifecycleState ... targetStates) {
        final HashSet<VirtualDeployment.LifecycleState> targetStatesSet = new HashSet<VirtualDeployment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVirtualDeploymentRequest, GetVirtualDeploymentResponse>(){

            @Override
            public GetVirtualDeploymentResponse apply(GetVirtualDeploymentRequest request) {
                return ServiceMeshWaiters.this.client.getVirtualDeployment(request);
            }
        }, (Predicate)new Predicate<GetVirtualDeploymentResponse>(){

            @Override
            public boolean test(GetVirtualDeploymentResponse response) {
                return targetStatesSet.contains((Object)response.getVirtualDeployment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VirtualDeployment.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVirtualServiceRequest, GetVirtualServiceResponse> forVirtualService(GetVirtualServiceRequest request, VirtualService.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualService(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVirtualServiceRequest, GetVirtualServiceResponse> forVirtualService(GetVirtualServiceRequest request, VirtualService.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVirtualService(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVirtualServiceRequest, GetVirtualServiceResponse> forVirtualService(GetVirtualServiceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VirtualService.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVirtualService(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVirtualServiceRequest, GetVirtualServiceResponse> forVirtualService(BmcGenericWaiter waiter, GetVirtualServiceRequest request, VirtualService.LifecycleState ... targetStates) {
        final HashSet<VirtualService.LifecycleState> targetStatesSet = new HashSet<VirtualService.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVirtualServiceRequest, GetVirtualServiceResponse>(){

            @Override
            public GetVirtualServiceResponse apply(GetVirtualServiceRequest request) {
                return ServiceMeshWaiters.this.client.getVirtualService(request);
            }
        }, (Predicate)new Predicate<GetVirtualServiceResponse>(){

            @Override
            public boolean test(GetVirtualServiceResponse response) {
                return targetStatesSet.contains((Object)response.getVirtualService().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VirtualService.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVirtualServiceRouteTableRequest, GetVirtualServiceRouteTableResponse> forVirtualServiceRouteTable(GetVirtualServiceRouteTableRequest request, VirtualServiceRouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualServiceRouteTable(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVirtualServiceRouteTableRequest, GetVirtualServiceRouteTableResponse> forVirtualServiceRouteTable(GetVirtualServiceRouteTableRequest request, VirtualServiceRouteTable.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVirtualServiceRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVirtualServiceRouteTableRequest, GetVirtualServiceRouteTableResponse> forVirtualServiceRouteTable(GetVirtualServiceRouteTableRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VirtualServiceRouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVirtualServiceRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVirtualServiceRouteTableRequest, GetVirtualServiceRouteTableResponse> forVirtualServiceRouteTable(BmcGenericWaiter waiter, GetVirtualServiceRouteTableRequest request, VirtualServiceRouteTable.LifecycleState ... targetStates) {
        final HashSet<VirtualServiceRouteTable.LifecycleState> targetStatesSet = new HashSet<VirtualServiceRouteTable.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVirtualServiceRouteTableRequest, GetVirtualServiceRouteTableResponse>(){

            @Override
            public GetVirtualServiceRouteTableResponse apply(GetVirtualServiceRouteTableRequest request) {
                return ServiceMeshWaiters.this.client.getVirtualServiceRouteTable(request);
            }
        }, (Predicate)new Predicate<GetVirtualServiceRouteTableResponse>(){

            @Override
            public boolean test(GetVirtualServiceRouteTableResponse response) {
                return targetStatesSet.contains((Object)response.getVirtualServiceRouteTable().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VirtualServiceRouteTable.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ServiceMeshWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

