/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MutualTransportLayerSecurity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="certificateId")
    private final String certificateId;
    @JsonProperty(value="maximumValidity")
    private final Integer maximumValidity;
    @JsonProperty(value="mode")
    private final Mode mode;

    @Deprecated
    @ConstructorProperties(value={"certificateId", "maximumValidity", "mode"})
    public MutualTransportLayerSecurity(String certificateId, Integer maximumValidity, Mode mode) {
        this.certificateId = certificateId;
        this.maximumValidity = maximumValidity;
        this.mode = mode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public Integer getMaximumValidity() {
        return this.maximumValidity;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MutualTransportLayerSecurity(");
        sb.append("super=").append(super.toString());
        sb.append("certificateId=").append(String.valueOf(this.certificateId));
        sb.append(", maximumValidity=").append(String.valueOf(this.maximumValidity));
        sb.append(", mode=").append(String.valueOf((Object)this.mode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MutualTransportLayerSecurity)) {
            return false;
        }
        MutualTransportLayerSecurity other = (MutualTransportLayerSecurity)((Object)o);
        return Objects.equals(this.certificateId, other.certificateId) && Objects.equals(this.maximumValidity, other.maximumValidity) && Objects.equals((Object)this.mode, (Object)other.mode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.maximumValidity == null ? 43 : this.maximumValidity.hashCode());
        result = result * 59 + (this.mode == null ? 43 : this.mode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Mode implements BmcEnum
    {
        Disabled("DISABLED"),
        Permissive("PERMISSIVE"),
        Strict("STRICT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Mode> map;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Mode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Mode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Mode.class);
            map = new HashMap<String, Mode>();
            for (Mode v : Mode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="certificateId")
        private String certificateId;
        @JsonProperty(value="maximumValidity")
        private Integer maximumValidity;
        @JsonProperty(value="mode")
        private Mode mode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            this.__explicitlySet__.add("certificateId");
            return this;
        }

        public Builder maximumValidity(Integer maximumValidity) {
            this.maximumValidity = maximumValidity;
            this.__explicitlySet__.add("maximumValidity");
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            this.__explicitlySet__.add("mode");
            return this;
        }

        public MutualTransportLayerSecurity build() {
            MutualTransportLayerSecurity model = new MutualTransportLayerSecurity(this.certificateId, this.maximumValidity, this.mode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MutualTransportLayerSecurity model) {
            if (model.wasPropertyExplicitlySet("certificateId")) {
                this.certificateId(model.getCertificateId());
            }
            if (model.wasPropertyExplicitlySet("maximumValidity")) {
                this.maximumValidity(model.getMaximumValidity());
            }
            if (model.wasPropertyExplicitlySet("mode")) {
                this.mode(model.getMode());
            }
            return this;
        }
    }
}

