/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.servicemesh.model.AccessLoggingConfiguration;
import com.oracle.bmc.servicemesh.model.ServiceDiscoveryConfiguration;
import com.oracle.bmc.servicemesh.model.VirtualDeploymentListener;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateVirtualDeploymentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="serviceDiscovery")
    private final ServiceDiscoveryConfiguration serviceDiscovery;
    @JsonProperty(value="listeners")
    private final List<VirtualDeploymentListener> listeners;
    @JsonProperty(value="accessLogging")
    private final AccessLoggingConfiguration accessLogging;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"description", "serviceDiscovery", "listeners", "accessLogging", "freeformTags", "definedTags"})
    public UpdateVirtualDeploymentDetails(String description, ServiceDiscoveryConfiguration serviceDiscovery, List<VirtualDeploymentListener> listeners, AccessLoggingConfiguration accessLogging, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.description = description;
        this.serviceDiscovery = serviceDiscovery;
        this.listeners = listeners;
        this.accessLogging = accessLogging;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public ServiceDiscoveryConfiguration getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public List<VirtualDeploymentListener> getListeners() {
        return this.listeners;
    }

    public AccessLoggingConfiguration getAccessLogging() {
        return this.accessLogging;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateVirtualDeploymentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", serviceDiscovery=").append(String.valueOf((Object)this.serviceDiscovery));
        sb.append(", listeners=").append(String.valueOf(this.listeners));
        sb.append(", accessLogging=").append(String.valueOf((Object)this.accessLogging));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVirtualDeploymentDetails)) {
            return false;
        }
        UpdateVirtualDeploymentDetails other = (UpdateVirtualDeploymentDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals((Object)this.serviceDiscovery, (Object)other.serviceDiscovery) && Objects.equals(this.listeners, other.listeners) && Objects.equals((Object)this.accessLogging, (Object)other.accessLogging) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.serviceDiscovery == null ? 43 : this.serviceDiscovery.hashCode());
        result = result * 59 + (this.listeners == null ? 43 : this.listeners.hashCode());
        result = result * 59 + (this.accessLogging == null ? 43 : this.accessLogging.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="serviceDiscovery")
        private ServiceDiscoveryConfiguration serviceDiscovery;
        @JsonProperty(value="listeners")
        private List<VirtualDeploymentListener> listeners;
        @JsonProperty(value="accessLogging")
        private AccessLoggingConfiguration accessLogging;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder serviceDiscovery(ServiceDiscoveryConfiguration serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            this.__explicitlySet__.add("serviceDiscovery");
            return this;
        }

        public Builder listeners(List<VirtualDeploymentListener> listeners) {
            this.listeners = listeners;
            this.__explicitlySet__.add("listeners");
            return this;
        }

        public Builder accessLogging(AccessLoggingConfiguration accessLogging) {
            this.accessLogging = accessLogging;
            this.__explicitlySet__.add("accessLogging");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateVirtualDeploymentDetails build() {
            UpdateVirtualDeploymentDetails model = new UpdateVirtualDeploymentDetails(this.description, this.serviceDiscovery, this.listeners, this.accessLogging, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateVirtualDeploymentDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("serviceDiscovery")) {
                this.serviceDiscovery(model.getServiceDiscovery());
            }
            if (model.wasPropertyExplicitlySet("listeners")) {
                this.listeners(model.getListeners());
            }
            if (model.wasPropertyExplicitlySet("accessLogging")) {
                this.accessLogging(model.getAccessLogging());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

