/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VirtualDeploymentListener
extends ExplicitlySetBmcModel {
    @JsonProperty(value="protocol")
    private final Protocol protocol;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="requestTimeoutInMs")
    private final Long requestTimeoutInMs;
    @JsonProperty(value="idleTimeoutInMs")
    private final Long idleTimeoutInMs;

    @Deprecated
    @ConstructorProperties(value={"protocol", "port", "requestTimeoutInMs", "idleTimeoutInMs"})
    public VirtualDeploymentListener(Protocol protocol, Integer port, Long requestTimeoutInMs, Long idleTimeoutInMs) {
        this.protocol = protocol;
        this.port = port;
        this.requestTimeoutInMs = requestTimeoutInMs;
        this.idleTimeoutInMs = idleTimeoutInMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Integer getPort() {
        return this.port;
    }

    public Long getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    public Long getIdleTimeoutInMs() {
        return this.idleTimeoutInMs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualDeploymentListener(");
        sb.append("super=").append(super.toString());
        sb.append("protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", requestTimeoutInMs=").append(String.valueOf(this.requestTimeoutInMs));
        sb.append(", idleTimeoutInMs=").append(String.valueOf(this.idleTimeoutInMs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDeploymentListener)) {
            return false;
        }
        VirtualDeploymentListener other = (VirtualDeploymentListener)((Object)o);
        return Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals(this.port, other.port) && Objects.equals(this.requestTimeoutInMs, other.requestTimeoutInMs) && Objects.equals(this.idleTimeoutInMs, other.idleTimeoutInMs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.requestTimeoutInMs == null ? 43 : this.requestTimeoutInMs.hashCode());
        result = result * 59 + (this.idleTimeoutInMs == null ? 43 : this.idleTimeoutInMs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Protocol implements BmcEnum
    {
        Http("HTTP"),
        TlsPassthrough("TLS_PASSTHROUGH"),
        Tcp("TCP"),
        Http2("HTTP2"),
        Grpc("GRPC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Protocol', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Protocol.class);
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="requestTimeoutInMs")
        private Long requestTimeoutInMs;
        @JsonProperty(value="idleTimeoutInMs")
        private Long idleTimeoutInMs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder requestTimeoutInMs(Long requestTimeoutInMs) {
            this.requestTimeoutInMs = requestTimeoutInMs;
            this.__explicitlySet__.add("requestTimeoutInMs");
            return this;
        }

        public Builder idleTimeoutInMs(Long idleTimeoutInMs) {
            this.idleTimeoutInMs = idleTimeoutInMs;
            this.__explicitlySet__.add("idleTimeoutInMs");
            return this;
        }

        public VirtualDeploymentListener build() {
            VirtualDeploymentListener model = new VirtualDeploymentListener(this.protocol, this.port, this.requestTimeoutInMs, this.idleTimeoutInMs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VirtualDeploymentListener model) {
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("requestTimeoutInMs")) {
                this.requestTimeoutInMs(model.getRequestTimeoutInMs());
            }
            if (model.wasPropertyExplicitlySet("idleTimeoutInMs")) {
                this.idleTimeoutInMs(model.getIdleTimeoutInMs());
            }
            return this;
        }
    }
}

