/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.servicemesh.model.TrafficRuleTargetDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class VirtualServiceTrafficRuleTargetDetails
extends TrafficRuleTargetDetails {
    @JsonProperty(value="virtualServiceId")
    private final String virtualServiceId;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="weight")
    private final Integer weight;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VirtualServiceTrafficRuleTargetDetails(String virtualServiceId, Integer port, Integer weight) {
        this.virtualServiceId = virtualServiceId;
        this.port = port;
        this.weight = weight;
    }

    public String getVirtualServiceId() {
        return this.virtualServiceId;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualServiceTrafficRuleTargetDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", virtualServiceId=").append(String.valueOf(this.virtualServiceId));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", weight=").append(String.valueOf(this.weight));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualServiceTrafficRuleTargetDetails)) {
            return false;
        }
        VirtualServiceTrafficRuleTargetDetails other = (VirtualServiceTrafficRuleTargetDetails)((Object)o);
        return Objects.equals(this.virtualServiceId, other.virtualServiceId) && Objects.equals(this.port, other.port) && Objects.equals(this.weight, other.weight) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.virtualServiceId == null ? 43 : this.virtualServiceId.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.weight == null ? 43 : this.weight.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="virtualServiceId")
        private String virtualServiceId;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="weight")
        private Integer weight;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder virtualServiceId(String virtualServiceId) {
            this.virtualServiceId = virtualServiceId;
            this.__explicitlySet__.add("virtualServiceId");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            this.__explicitlySet__.add("weight");
            return this;
        }

        public VirtualServiceTrafficRuleTargetDetails build() {
            VirtualServiceTrafficRuleTargetDetails model = new VirtualServiceTrafficRuleTargetDetails(this.virtualServiceId, this.port, this.weight);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VirtualServiceTrafficRuleTargetDetails model) {
            if (model.wasPropertyExplicitlySet("virtualServiceId")) {
                this.virtualServiceId(model.getVirtualServiceId());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("weight")) {
                this.weight(model.getWeight());
            }
            return this;
        }
    }
}

