/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.servicemesh.model.CreateVirtualServiceDetails;
import java.util.Objects;

public class CreateVirtualServiceRequest
extends BmcRequest<CreateVirtualServiceDetails> {
    private CreateVirtualServiceDetails createVirtualServiceDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreateVirtualServiceDetails getCreateVirtualServiceDetails() {
        return this.createVirtualServiceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateVirtualServiceDetails getBody$() {
        return this.createVirtualServiceDetails;
    }

    public Builder toBuilder() {
        return new Builder().createVirtualServiceDetails(this.createVirtualServiceDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createVirtualServiceDetails=").append(String.valueOf((Object)this.createVirtualServiceDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateVirtualServiceRequest)) {
            return false;
        }
        CreateVirtualServiceRequest other = (CreateVirtualServiceRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createVirtualServiceDetails, (Object)other.createVirtualServiceDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createVirtualServiceDetails == null ? 43 : this.createVirtualServiceDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateVirtualServiceRequest, CreateVirtualServiceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateVirtualServiceDetails createVirtualServiceDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createVirtualServiceDetails(CreateVirtualServiceDetails createVirtualServiceDetails) {
            this.createVirtualServiceDetails = createVirtualServiceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateVirtualServiceRequest o) {
            this.createVirtualServiceDetails(o.getCreateVirtualServiceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateVirtualServiceRequest build() {
            CreateVirtualServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateVirtualServiceDetails body) {
            this.createVirtualServiceDetails(body);
            return this;
        }

        public CreateVirtualServiceRequest buildWithoutInvocationCallback() {
            CreateVirtualServiceRequest request = new CreateVirtualServiceRequest();
            request.createVirtualServiceDetails = this.createVirtualServiceDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

