/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.servicemesh.model.UpdateVirtualServiceDetails;
import java.util.Objects;

public class UpdateVirtualServiceRequest
extends BmcRequest<UpdateVirtualServiceDetails> {
    private String virtualServiceId;
    private UpdateVirtualServiceDetails updateVirtualServiceDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getVirtualServiceId() {
        return this.virtualServiceId;
    }

    public UpdateVirtualServiceDetails getUpdateVirtualServiceDetails() {
        return this.updateVirtualServiceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateVirtualServiceDetails getBody$() {
        return this.updateVirtualServiceDetails;
    }

    public Builder toBuilder() {
        return new Builder().virtualServiceId(this.virtualServiceId).updateVirtualServiceDetails(this.updateVirtualServiceDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",virtualServiceId=").append(String.valueOf(this.virtualServiceId));
        sb.append(",updateVirtualServiceDetails=").append(String.valueOf((Object)this.updateVirtualServiceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVirtualServiceRequest)) {
            return false;
        }
        UpdateVirtualServiceRequest other = (UpdateVirtualServiceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.virtualServiceId, other.virtualServiceId) && Objects.equals((Object)this.updateVirtualServiceDetails, (Object)other.updateVirtualServiceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.virtualServiceId == null ? 43 : this.virtualServiceId.hashCode());
        result = result * 59 + (this.updateVirtualServiceDetails == null ? 43 : this.updateVirtualServiceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateVirtualServiceRequest, UpdateVirtualServiceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String virtualServiceId = null;
        private UpdateVirtualServiceDetails updateVirtualServiceDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder virtualServiceId(String virtualServiceId) {
            this.virtualServiceId = virtualServiceId;
            return this;
        }

        public Builder updateVirtualServiceDetails(UpdateVirtualServiceDetails updateVirtualServiceDetails) {
            this.updateVirtualServiceDetails = updateVirtualServiceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVirtualServiceRequest o) {
            this.virtualServiceId(o.getVirtualServiceId());
            this.updateVirtualServiceDetails(o.getUpdateVirtualServiceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVirtualServiceRequest build() {
            UpdateVirtualServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateVirtualServiceDetails body) {
            this.updateVirtualServiceDetails(body);
            return this;
        }

        public UpdateVirtualServiceRequest buildWithoutInvocationCallback() {
            UpdateVirtualServiceRequest request = new UpdateVirtualServiceRequest();
            request.virtualServiceId = this.virtualServiceId;
            request.updateVirtualServiceDetails = this.updateVirtualServiceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

