/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.streaming.model.Message;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMessagesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetMessagesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetMessagesRequest interceptRequest(GetMessagesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetMessagesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCursor(), (String)"cursor is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180418").path("streams").path(HttpUtils.encodePathSegment((String)request.getStreamId())).path("messages");
        target = target.queryParam("cursor", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCursor())});
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetMessagesResponse> fromResponse() {
        Function<Response, GetMessagesResponse> transformer = new Function<Response, GetMessagesResponse>(){

            public GetMessagesResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetMessagesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<Message>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetMessagesResponse.Builder builder = GetMessagesResponse.builder();
                builder.items((List)response.getItem());
                Optional opcNextCursorHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-cursor");
                if (opcNextCursorHeader.isPresent()) {
                    builder.opcNextCursor((String)HeaderUtils.toValue((String)"opc-next-cursor", (String)((String)((List)opcNextCursorHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetMessagesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

