/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.CreateArchiverDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateArchiverRequest
extends BmcRequest {
    private String streamId;
    private CreateArchiverDetails createArchiverDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"streamId", "createArchiverDetails", "opcRequestId", "opcRetryToken"})
    CreateArchiverRequest(String streamId, CreateArchiverDetails createArchiverDetails, String opcRequestId, String opcRetryToken) {
        this.streamId = streamId;
        this.createArchiverDetails = createArchiverDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamId() {
        return this.streamId;
    }

    public CreateArchiverDetails getCreateArchiverDetails() {
        return this.createArchiverDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String streamId;
        private CreateArchiverDetails createArchiverDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateArchiverRequest o) {
            this.streamId(o.getStreamId());
            this.createArchiverDetails(o.getCreateArchiverDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateArchiverRequest build() {
            CreateArchiverRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder createArchiverDetails(CreateArchiverDetails createArchiverDetails) {
            this.createArchiverDetails = createArchiverDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateArchiverRequest buildWithoutInvocationCallback() {
            return new CreateArchiverRequest(this.streamId, this.createArchiverDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateArchiverRequest.Builder(streamId=" + this.streamId + ", createArchiverDetails=" + this.createArchiverDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

