/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.CreateGroupCursorDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateGroupCursorRequest
extends BmcRequest {
    private String streamId;
    private CreateGroupCursorDetails createGroupCursorDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"streamId", "createGroupCursorDetails", "opcRequestId"})
    CreateGroupCursorRequest(String streamId, CreateGroupCursorDetails createGroupCursorDetails, String opcRequestId) {
        this.streamId = streamId;
        this.createGroupCursorDetails = createGroupCursorDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamId() {
        return this.streamId;
    }

    public CreateGroupCursorDetails getCreateGroupCursorDetails() {
        return this.createGroupCursorDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String streamId;
        private CreateGroupCursorDetails createGroupCursorDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateGroupCursorRequest o) {
            this.streamId(o.getStreamId());
            this.createGroupCursorDetails(o.getCreateGroupCursorDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateGroupCursorRequest build() {
            CreateGroupCursorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder createGroupCursorDetails(CreateGroupCursorDetails createGroupCursorDetails) {
            this.createGroupCursorDetails = createGroupCursorDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateGroupCursorRequest buildWithoutInvocationCallback() {
            return new CreateGroupCursorRequest(this.streamId, this.createGroupCursorDetails, this.opcRequestId);
        }

        public String toString() {
            return "CreateGroupCursorRequest.Builder(streamId=" + this.streamId + ", createGroupCursorDetails=" + this.createGroupCursorDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

