/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.CreateStreamDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateStreamRequest
extends BmcRequest {
    private CreateStreamDetails createStreamDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"createStreamDetails", "opcRequestId"})
    CreateStreamRequest(CreateStreamDetails createStreamDetails, String opcRequestId) {
        this.createStreamDetails = createStreamDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateStreamDetails getCreateStreamDetails() {
        return this.createStreamDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private CreateStreamDetails createStreamDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateStreamRequest o) {
            this.createStreamDetails(o.getCreateStreamDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateStreamRequest build() {
            CreateStreamRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createStreamDetails(CreateStreamDetails createStreamDetails) {
            this.createStreamDetails = createStreamDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateStreamRequest buildWithoutInvocationCallback() {
            return new CreateStreamRequest(this.createStreamDetails, this.opcRequestId);
        }

        public String toString() {
            return "CreateStreamRequest.Builder(createStreamDetails=" + this.createStreamDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

