/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConnectHarnessRequest
extends BmcRequest {
    private String connectHarnessId;
    private String opcRequestId;

    @ConstructorProperties(value={"connectHarnessId", "opcRequestId"})
    GetConnectHarnessRequest(String connectHarnessId, String opcRequestId) {
        this.connectHarnessId = connectHarnessId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getConnectHarnessId() {
        return this.connectHarnessId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String connectHarnessId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConnectHarnessRequest o) {
            this.connectHarnessId(o.getConnectHarnessId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConnectHarnessRequest build() {
            GetConnectHarnessRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder connectHarnessId(String connectHarnessId) {
            this.connectHarnessId = connectHarnessId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetConnectHarnessRequest buildWithoutInvocationCallback() {
            return new GetConnectHarnessRequest(this.connectHarnessId, this.opcRequestId);
        }

        public String toString() {
            return "GetConnectHarnessRequest.Builder(connectHarnessId=" + this.connectHarnessId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

