/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetStreamPoolRequest
extends BmcRequest {
    private String streamPoolId;
    private String opcRequestId;

    @ConstructorProperties(value={"streamPoolId", "opcRequestId"})
    GetStreamPoolRequest(String streamPoolId, String opcRequestId) {
        this.streamPoolId = streamPoolId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamPoolId() {
        return this.streamPoolId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String streamPoolId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStreamPoolRequest o) {
            this.streamPoolId(o.getStreamPoolId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStreamPoolRequest build() {
            GetStreamPoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder streamPoolId(String streamPoolId) {
            this.streamPoolId = streamPoolId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetStreamPoolRequest buildWithoutInvocationCallback() {
            return new GetStreamPoolRequest(this.streamPoolId, this.opcRequestId);
        }

        public String toString() {
            return "GetStreamPoolRequest.Builder(streamPoolId=" + this.streamPoolId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

