/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.UpdateArchiverDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateArchiverRequest
extends BmcRequest {
    private String streamId;
    private UpdateArchiverDetails updateArchiverDetails;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"streamId", "updateArchiverDetails", "opcRequestId", "ifMatch"})
    UpdateArchiverRequest(String streamId, UpdateArchiverDetails updateArchiverDetails, String opcRequestId, String ifMatch) {
        this.streamId = streamId;
        this.updateArchiverDetails = updateArchiverDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamId() {
        return this.streamId;
    }

    public UpdateArchiverDetails getUpdateArchiverDetails() {
        return this.updateArchiverDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String streamId;
        private UpdateArchiverDetails updateArchiverDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateArchiverRequest o) {
            this.streamId(o.getStreamId());
            this.updateArchiverDetails(o.getUpdateArchiverDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateArchiverRequest build() {
            UpdateArchiverRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder updateArchiverDetails(UpdateArchiverDetails updateArchiverDetails) {
            this.updateArchiverDetails = updateArchiverDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateArchiverRequest buildWithoutInvocationCallback() {
            return new UpdateArchiverRequest(this.streamId, this.updateArchiverDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateArchiverRequest.Builder(streamId=" + this.streamId + ", updateArchiverDetails=" + this.updateArchiverDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

