/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.UpdateStreamPoolDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateStreamPoolRequest
extends BmcRequest {
    private String streamPoolId;
    private UpdateStreamPoolDetails updateStreamPoolDetails;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"streamPoolId", "updateStreamPoolDetails", "opcRequestId", "ifMatch"})
    UpdateStreamPoolRequest(String streamPoolId, UpdateStreamPoolDetails updateStreamPoolDetails, String opcRequestId, String ifMatch) {
        this.streamPoolId = streamPoolId;
        this.updateStreamPoolDetails = updateStreamPoolDetails;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamPoolId() {
        return this.streamPoolId;
    }

    public UpdateStreamPoolDetails getUpdateStreamPoolDetails() {
        return this.updateStreamPoolDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String streamPoolId;
        private UpdateStreamPoolDetails updateStreamPoolDetails;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateStreamPoolRequest o) {
            this.streamPoolId(o.getStreamPoolId());
            this.updateStreamPoolDetails(o.getUpdateStreamPoolDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateStreamPoolRequest build() {
            UpdateStreamPoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder streamPoolId(String streamPoolId) {
            this.streamPoolId = streamPoolId;
            return this;
        }

        public Builder updateStreamPoolDetails(UpdateStreamPoolDetails updateStreamPoolDetails) {
            this.updateStreamPoolDetails = updateStreamPoolDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateStreamPoolRequest buildWithoutInvocationCallback() {
            return new UpdateStreamPoolRequest(this.streamPoolId, this.updateStreamPoolDetails, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateStreamPoolRequest.Builder(streamPoolId=" + this.streamPoolId + ", updateStreamPoolDetails=" + this.updateStreamPoolDetails + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

