/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.ConnectHarness;
import java.beans.ConstructorProperties;

public class CreateConnectHarnessResponse {
    private String opcRequestId;
    private String etag;
    private ConnectHarness connectHarness;

    @ConstructorProperties(value={"opcRequestId", "etag", "connectHarness"})
    CreateConnectHarnessResponse(String opcRequestId, String etag, ConnectHarness connectHarness) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.connectHarness = connectHarness;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ConnectHarness getConnectHarness() {
        return this.connectHarness;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private ConnectHarness connectHarness;

        public Builder copy(CreateConnectHarnessResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.connectHarness(o.getConnectHarness());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder connectHarness(ConnectHarness connectHarness) {
            this.connectHarness = connectHarness;
            return this;
        }

        public CreateConnectHarnessResponse build() {
            return new CreateConnectHarnessResponse(this.opcRequestId, this.etag, this.connectHarness);
        }

        public String toString() {
            return "CreateConnectHarnessResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", connectHarness=" + this.connectHarness + ")";
        }
    }
}

