/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.Cursor;
import java.beans.ConstructorProperties;

public class CreateCursorResponse {
    private String opcRequestId;
    private Cursor cursor;

    @ConstructorProperties(value={"opcRequestId", "cursor"})
    CreateCursorResponse(String opcRequestId, Cursor cursor) {
        this.opcRequestId = opcRequestId;
        this.cursor = cursor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public static class Builder {
        private String opcRequestId;
        private Cursor cursor;

        public Builder copy(CreateCursorResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.cursor(o.getCursor());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder cursor(Cursor cursor) {
            this.cursor = cursor;
            return this;
        }

        public CreateCursorResponse build() {
            return new CreateCursorResponse(this.opcRequestId, this.cursor);
        }

        public String toString() {
            return "CreateCursorResponse.Builder(opcRequestId=" + this.opcRequestId + ", cursor=" + this.cursor + ")";
        }
    }
}

