/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.StreamPool;
import java.beans.ConstructorProperties;

public class CreateStreamPoolResponse {
    private String opcRequestId;
    private String etag;
    private StreamPool streamPool;

    @ConstructorProperties(value={"opcRequestId", "etag", "streamPool"})
    CreateStreamPoolResponse(String opcRequestId, String etag, StreamPool streamPool) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.streamPool = streamPool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public StreamPool getStreamPool() {
        return this.streamPool;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private StreamPool streamPool;

        public Builder copy(CreateStreamPoolResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.streamPool(o.getStreamPool());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder streamPool(StreamPool streamPool) {
            this.streamPool = streamPool;
            return this;
        }

        public CreateStreamPoolResponse build() {
            return new CreateStreamPoolResponse(this.opcRequestId, this.etag, this.streamPool);
        }

        public String toString() {
            return "CreateStreamPoolResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", streamPool=" + this.streamPool + ")";
        }
    }
}

