/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.responses;

import com.oracle.bmc.streaming.model.ConnectHarnessSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListConnectHarnessesResponse {
    private String opcNextPage;
    private String opcPrevPage;
    private String opcRequestId;
    private List<ConnectHarnessSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcPrevPage", "opcRequestId", "items"})
    ListConnectHarnessesResponse(String opcNextPage, String opcPrevPage, String opcRequestId, List<ConnectHarnessSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcPrevPage = opcPrevPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcPrevPage() {
        return this.opcPrevPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ConnectHarnessSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcPrevPage;
        private String opcRequestId;
        private List<ConnectHarnessSummary> items;

        public Builder copy(ListConnectHarnessesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcPrevPage(o.getOpcPrevPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcPrevPage(String opcPrevPage) {
            this.opcPrevPage = opcPrevPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<ConnectHarnessSummary> items) {
            this.items = items;
            return this;
        }

        public ListConnectHarnessesResponse build() {
            return new ListConnectHarnessesResponse(this.opcNextPage, this.opcPrevPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListConnectHarnessesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcPrevPage=" + this.opcPrevPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

