/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.StreamAdminPaginators;
import com.oracle.bmc.streaming.StreamAdminWaiters;
import com.oracle.bmc.streaming.internal.http.ChangeConnectHarnessCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamPoolCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.CreateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.DeleteConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.GetConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.ListConnectHarnessesConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamPoolsConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamsConverter;
import com.oracle.bmc.streaming.internal.http.UpdateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamPoolConverter;
import com.oracle.bmc.streaming.requests.ChangeConnectHarnessCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamPoolCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.CreateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamPoolRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.UpdateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeConnectHarnessCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamPoolCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.CreateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamPoolResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.UpdateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminClient
implements StreamAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final StreamAdminWaiters waiters;
    private final StreamAdminPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StreamAdmin-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new StreamAdminWaiters(executorService, this);
        this.paginators = new StreamAdminPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeConnectHarnessCompartmentResponse changeConnectHarnessCompartment(ChangeConnectHarnessCompartmentRequest request) {
        LOG.trace("Called changeConnectHarnessCompartment");
        ChangeConnectHarnessCompartmentRequest interceptedRequest = ChangeConnectHarnessCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeConnectHarnessCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeConnectHarnessCompartmentResponse> transformer = ChangeConnectHarnessCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeConnectHarnessCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeConnectHarnessCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeConnectHarnessCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeConnectHarnessCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeStreamCompartmentResponse changeStreamCompartment(ChangeStreamCompartmentRequest request) {
        LOG.trace("Called changeStreamCompartment");
        ChangeStreamCompartmentRequest interceptedRequest = ChangeStreamCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStreamCompartmentResponse> transformer = ChangeStreamCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeStreamCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeStreamCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeStreamCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeStreamCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeStreamPoolCompartmentResponse changeStreamPoolCompartment(ChangeStreamPoolCompartmentRequest request) {
        LOG.trace("Called changeStreamPoolCompartment");
        ChangeStreamPoolCompartmentRequest interceptedRequest = ChangeStreamPoolCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamPoolCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStreamPoolCompartmentResponse> transformer = ChangeStreamPoolCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeStreamPoolCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeStreamPoolCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeStreamPoolCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeStreamPoolCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateConnectHarnessResponse createConnectHarness(CreateConnectHarnessRequest request) {
        LOG.trace("Called createConnectHarness");
        CreateConnectHarnessRequest interceptedRequest = CreateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConnectHarnessResponse> transformer = CreateConnectHarnessConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateConnectHarnessResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateConnectHarnessResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateConnectHarnessDetails(), (BmcRequest)retriedRequest);
                return (CreateConnectHarnessResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateStreamResponse createStream(CreateStreamRequest request) {
        LOG.trace("Called createStream");
        CreateStreamRequest interceptedRequest = CreateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStreamResponse> transformer = CreateStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateStreamResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateStreamResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateStreamDetails(), (BmcRequest)retriedRequest);
                return (CreateStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateStreamPoolResponse createStreamPool(CreateStreamPoolRequest request) {
        LOG.trace("Called createStreamPool");
        CreateStreamPoolRequest interceptedRequest = CreateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStreamPoolResponse> transformer = CreateStreamPoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateStreamPoolResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateStreamPoolResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateStreamPoolDetails(), (BmcRequest)retriedRequest);
                return (CreateStreamPoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteConnectHarnessResponse deleteConnectHarness(DeleteConnectHarnessRequest request) {
        LOG.trace("Called deleteConnectHarness");
        DeleteConnectHarnessRequest interceptedRequest = DeleteConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConnectHarnessResponse> transformer = DeleteConnectHarnessConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteConnectHarnessResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteConnectHarnessResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteConnectHarnessResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest request) {
        LOG.trace("Called deleteStream");
        DeleteStreamRequest interceptedRequest = DeleteStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStreamResponse> transformer = DeleteStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteStreamResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteStreamResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteStreamPoolResponse deleteStreamPool(DeleteStreamPoolRequest request) {
        LOG.trace("Called deleteStreamPool");
        DeleteStreamPoolRequest interceptedRequest = DeleteStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStreamPoolResponse> transformer = DeleteStreamPoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteStreamPoolResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteStreamPoolResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteStreamPoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConnectHarnessResponse getConnectHarness(GetConnectHarnessRequest request) {
        LOG.trace("Called getConnectHarness");
        GetConnectHarnessRequest interceptedRequest = GetConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConnectHarnessResponse> transformer = GetConnectHarnessConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConnectHarnessResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConnectHarnessResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConnectHarnessResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStreamResponse getStream(GetStreamRequest request) {
        LOG.trace("Called getStream");
        GetStreamRequest interceptedRequest = GetStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStreamResponse> transformer = GetStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStreamResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStreamResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStreamPoolResponse getStreamPool(GetStreamPoolRequest request) {
        LOG.trace("Called getStreamPool");
        GetStreamPoolRequest interceptedRequest = GetStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStreamPoolResponse> transformer = GetStreamPoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStreamPoolResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStreamPoolResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStreamPoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConnectHarnessesResponse listConnectHarnesses(ListConnectHarnessesRequest request) {
        LOG.trace("Called listConnectHarnesses");
        ListConnectHarnessesRequest interceptedRequest = ListConnectHarnessesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectHarnessesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConnectHarnessesResponse> transformer = ListConnectHarnessesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListConnectHarnessesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConnectHarnessesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConnectHarnessesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStreamPoolsResponse listStreamPools(ListStreamPoolsRequest request) {
        LOG.trace("Called listStreamPools");
        ListStreamPoolsRequest interceptedRequest = ListStreamPoolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamPoolsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStreamPoolsResponse> transformer = ListStreamPoolsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListStreamPoolsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStreamPoolsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListStreamPoolsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest request) {
        LOG.trace("Called listStreams");
        ListStreamsRequest interceptedRequest = ListStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStreamsResponse> transformer = ListStreamsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListStreamsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStreamsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListStreamsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateConnectHarnessResponse updateConnectHarness(UpdateConnectHarnessRequest request) {
        LOG.trace("Called updateConnectHarness");
        UpdateConnectHarnessRequest interceptedRequest = UpdateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConnectHarnessResponse> transformer = UpdateConnectHarnessConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateConnectHarnessResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateConnectHarnessResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateConnectHarnessDetails(), (BmcRequest)retriedRequest);
                return (UpdateConnectHarnessResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateStreamResponse updateStream(UpdateStreamRequest request) {
        LOG.trace("Called updateStream");
        UpdateStreamRequest interceptedRequest = UpdateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStreamResponse> transformer = UpdateStreamConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateStreamResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateStreamResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateStreamDetails(), (BmcRequest)retriedRequest);
                return (UpdateStreamResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateStreamPoolResponse updateStreamPool(UpdateStreamPoolRequest request) {
        LOG.trace("Called updateStreamPool");
        UpdateStreamPoolRequest interceptedRequest = UpdateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStreamPoolResponse> transformer = UpdateStreamPoolConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateStreamPoolResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateStreamPoolResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateStreamPoolDetails(), (BmcRequest)retriedRequest);
                return (UpdateStreamPoolResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StreamAdminWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public StreamAdminPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public StreamAdminClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new StreamAdminClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

