/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.streaming.model.Cursor;
import com.oracle.bmc.streaming.requests.ConsumerHeartbeatRequest;
import com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerHeartbeatConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerHeartbeatConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ConsumerHeartbeatRequest interceptRequest(ConsumerHeartbeatRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ConsumerHeartbeatRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getStreamId(), (String)"streamId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCursor(), (String)"cursor is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180418").path("streams").path(HttpUtils.encodePathSegment((String)request.getStreamId())).path("heartbeat");
        target = target.queryParam("cursor", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCursor())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ConsumerHeartbeatResponse> fromResponse() {
        Function<Response, ConsumerHeartbeatResponse> transformer = new Function<Response, ConsumerHeartbeatResponse>(){

            public ConsumerHeartbeatResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Cursor.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ConsumerHeartbeatResponse.Builder builder = ConsumerHeartbeatResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.cursor((Cursor)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ConsumerHeartbeatResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

