/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CustomEncryptionKey {
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="keyState")
    private final KeyState keyState;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().kmsKeyId(this.kmsKeyId).keyState(this.keyState);
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public KeyState getKeyState() {
        return this.keyState;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomEncryptionKey)) {
            return false;
        }
        CustomEncryptionKey other = (CustomEncryptionKey)o;
        String this$kmsKeyId = this.getKmsKeyId();
        String other$kmsKeyId = other.getKmsKeyId();
        if (this$kmsKeyId == null ? other$kmsKeyId != null : !this$kmsKeyId.equals(other$kmsKeyId)) {
            return false;
        }
        KeyState this$keyState = this.getKeyState();
        KeyState other$keyState = other.getKeyState();
        if (this$keyState == null ? other$keyState != null : !((Object)((Object)this$keyState)).equals((Object)other$keyState)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $kmsKeyId = this.getKmsKeyId();
        result = result * 59 + ($kmsKeyId == null ? 43 : $kmsKeyId.hashCode());
        KeyState $keyState = this.getKeyState();
        result = result * 59 + ($keyState == null ? 43 : ((Object)((Object)$keyState)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "CustomEncryptionKey(kmsKeyId=" + this.getKmsKeyId() + ", keyState=" + (Object)((Object)this.getKeyState()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"kmsKeyId", "keyState"})
    @Deprecated
    public CustomEncryptionKey(String kmsKeyId, KeyState keyState) {
        this.kmsKeyId = kmsKeyId;
        this.keyState = keyState;
    }

    public static enum KeyState {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleting("DELETING"),
        None("NONE"),
        Failed("FAILED"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, KeyState> map;

        private KeyState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static KeyState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'KeyState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(KeyState.class);
            map = new HashMap<String, KeyState>();
            for (KeyState v : KeyState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="keyState")
        private KeyState keyState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder keyState(KeyState keyState) {
            this.keyState = keyState;
            this.__explicitlySet__.add("keyState");
            return this;
        }

        public CustomEncryptionKey build() {
            CustomEncryptionKey __instance__ = new CustomEncryptionKey(this.kmsKeyId, this.keyState);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CustomEncryptionKey o) {
            Builder copiedBuilder = this.kmsKeyId(o.getKmsKeyId()).keyState(o.getKeyState());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "CustomEncryptionKey.Builder(kmsKeyId=" + this.kmsKeyId + ", keyState=" + (Object)((Object)this.keyState) + ")";
        }
    }
}

