/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Message {
    @JsonProperty(value="stream")
    private final String stream;
    @JsonProperty(value="partition")
    private final String partition;
    @JsonProperty(value="key")
    private final byte[] key;
    @JsonProperty(value="value")
    private final byte[] value;
    @JsonProperty(value="offset")
    private final Long offset;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().stream(this.stream).partition(this.partition).key(this.key).value(this.value).offset(this.offset).timestamp(this.timestamp);
    }

    public String getStream() {
        return this.stream;
    }

    public String getPartition() {
        return this.partition;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        Long this$offset = this.getOffset();
        Long other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        String this$partition = this.getPartition();
        String other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        if (!Arrays.equals(this.getKey(), other.getKey())) {
            return false;
        }
        if (!Arrays.equals(this.getValue(), other.getValue())) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        String $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKey());
        result = result * 59 + Arrays.hashCode(this.getValue());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "Message(stream=" + this.getStream() + ", partition=" + this.getPartition() + ", key=" + Arrays.toString(this.getKey()) + ", value=" + Arrays.toString(this.getValue()) + ", offset=" + this.getOffset() + ", timestamp=" + this.getTimestamp() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"stream", "partition", "key", "value", "offset", "timestamp"})
    @Deprecated
    public Message(String stream, String partition, byte[] key, byte[] value, Long offset, Date timestamp) {
        this.stream = stream;
        this.partition = partition;
        this.key = key;
        this.value = value;
        this.offset = offset;
        this.timestamp = timestamp;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stream")
        private String stream;
        @JsonProperty(value="partition")
        private String partition;
        @JsonProperty(value="key")
        private byte[] key;
        @JsonProperty(value="value")
        private byte[] value;
        @JsonProperty(value="offset")
        private Long offset;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stream(String stream) {
            this.stream = stream;
            this.__explicitlySet__.add("stream");
            return this;
        }

        public Builder partition(String partition) {
            this.partition = partition;
            this.__explicitlySet__.add("partition");
            return this;
        }

        public Builder key(byte[] key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder value(byte[] value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder offset(Long offset) {
            this.offset = offset;
            this.__explicitlySet__.add("offset");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Message build() {
            Message __instance__ = new Message(this.stream, this.partition, this.key, this.value, this.offset, this.timestamp);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(Message o) {
            Builder copiedBuilder = this.stream(o.getStream()).partition(o.getPartition()).key(o.getKey()).value(o.getValue()).offset(o.getOffset()).timestamp(o.getTimestamp());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "Message.Builder(stream=" + this.stream + ", partition=" + this.partition + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ")";
        }
    }
}

