/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteConnectHarnessRequest
extends BmcRequest<Void> {
    private String connectHarnessId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"connectHarnessId", "opcRequestId", "ifMatch"})
    DeleteConnectHarnessRequest(String connectHarnessId, String opcRequestId, String ifMatch) {
        this.connectHarnessId = connectHarnessId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getConnectHarnessId() {
        return this.connectHarnessId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteConnectHarnessRequest, Void> {
        private String connectHarnessId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteConnectHarnessRequest o) {
            this.connectHarnessId(o.getConnectHarnessId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteConnectHarnessRequest build() {
            DeleteConnectHarnessRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder connectHarnessId(String connectHarnessId) {
            this.connectHarnessId = connectHarnessId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteConnectHarnessRequest buildWithoutInvocationCallback() {
            return new DeleteConnectHarnessRequest(this.connectHarnessId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteConnectHarnessRequest.Builder(connectHarnessId=" + this.connectHarnessId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

