/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.PutMessagesDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class PutMessagesRequest
extends BmcRequest<PutMessagesDetails> {
    private String streamId;
    private PutMessagesDetails putMessagesDetails;
    private String opcRequestId;

    @InternalSdk
    public PutMessagesDetails getBody$() {
        return this.putMessagesDetails;
    }

    @ConstructorProperties(value={"streamId", "putMessagesDetails", "opcRequestId"})
    PutMessagesRequest(String streamId, PutMessagesDetails putMessagesDetails, String opcRequestId) {
        this.streamId = streamId;
        this.putMessagesDetails = putMessagesDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamId() {
        return this.streamId;
    }

    public PutMessagesDetails getPutMessagesDetails() {
        return this.putMessagesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<PutMessagesRequest, PutMessagesDetails> {
        private String streamId;
        private PutMessagesDetails putMessagesDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutMessagesRequest o) {
            this.streamId(o.getStreamId());
            this.putMessagesDetails(o.getPutMessagesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutMessagesRequest build() {
            PutMessagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PutMessagesDetails body) {
            this.putMessagesDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder putMessagesDetails(PutMessagesDetails putMessagesDetails) {
            this.putMessagesDetails = putMessagesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public PutMessagesRequest buildWithoutInvocationCallback() {
            return new PutMessagesRequest(this.streamId, this.putMessagesDetails, this.opcRequestId);
        }

        public String toString() {
            return "PutMessagesRequest.Builder(streamId=" + this.streamId + ", putMessagesDetails=" + this.putMessagesDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

