/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.StreamAdminAsyncClient;
import com.oracle.bmc.streaming.StreamAdminPaginators;
import com.oracle.bmc.streaming.StreamAdminWaiters;
import com.oracle.bmc.streaming.internal.http.ChangeConnectHarnessCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamPoolCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.CreateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.DeleteConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.GetConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.ListConnectHarnessesConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamPoolsConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamsConverter;
import com.oracle.bmc.streaming.internal.http.UpdateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamPoolConverter;
import com.oracle.bmc.streaming.requests.ChangeConnectHarnessCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamPoolCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.CreateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamPoolRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.UpdateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeConnectHarnessCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamPoolCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.CreateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamPoolResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.UpdateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminClient
implements StreamAdmin {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminAsyncClient.class);
    private final StreamAdminWaiters waiters;
    private final StreamAdminPaginators paginators;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private final CircuitBreakerConfiguration circuitBreakerConfiguration;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    RestClient getClient() {
        return this.client;
    }

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAdminClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected StreamAdminClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.retryConfiguration = this.clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration userCircuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        this.circuitBreakerConfiguration = userCircuitBreakerConfiguration == null ? CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION : userCircuitBreakerConfiguration;
        this.refreshClient();
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("StreamAdmin-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new StreamAdminWaiters(executorService, this);
        this.paginators = new StreamAdminPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient, null, this.circuitBreakerConfiguration);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = GuavaUtils.adaptFromGuava((com.google.common.base.Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeConnectHarnessCompartmentResponse changeConnectHarnessCompartment(ChangeConnectHarnessCompartmentRequest request) {
        LOG.trace("Called changeConnectHarnessCompartment");
        ChangeConnectHarnessCompartmentRequest interceptedRequest = ChangeConnectHarnessCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeConnectHarnessCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ChangeConnectHarnessCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/ChangeConnectHarnessCompartment");
        Function<Response, ChangeConnectHarnessCompartmentResponse> transformer = ChangeConnectHarnessCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        return (ChangeConnectHarnessCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeConnectHarnessCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeConnectHarnessCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeConnectHarnessCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeStreamCompartmentResponse changeStreamCompartment(ChangeStreamCompartmentRequest request) {
        LOG.trace("Called changeStreamCompartment");
        ChangeStreamCompartmentRequest interceptedRequest = ChangeStreamCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ChangeStreamCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/ChangeStreamCompartment");
        Function<Response, ChangeStreamCompartmentResponse> transformer = ChangeStreamCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        return (ChangeStreamCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeStreamCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeStreamCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeStreamCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeStreamPoolCompartmentResponse changeStreamPoolCompartment(ChangeStreamPoolCompartmentRequest request) {
        LOG.trace("Called changeStreamPoolCompartment");
        ChangeStreamPoolCompartmentRequest interceptedRequest = ChangeStreamPoolCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamPoolCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ChangeStreamPoolCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/ChangeStreamPoolCompartment");
        Function<Response, ChangeStreamPoolCompartmentResponse> transformer = ChangeStreamPoolCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        return (ChangeStreamPoolCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeStreamPoolCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeStreamPoolCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeStreamPoolCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateConnectHarnessResponse createConnectHarness(CreateConnectHarnessRequest request) {
        LOG.trace("Called createConnectHarness");
        CreateConnectHarnessRequest interceptedRequest = CreateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "CreateConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/CreateConnectHarness");
        Function<Response, CreateConnectHarnessResponse> transformer = CreateConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateConnectHarnessResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateConnectHarnessResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateConnectHarnessDetails(), (BmcRequest)retriedRequest);
                return (CreateConnectHarnessResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateStreamResponse createStream(CreateStreamRequest request) {
        LOG.trace("Called createStream");
        CreateStreamRequest interceptedRequest = CreateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "CreateStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/CreateStream");
        Function<Response, CreateStreamResponse> transformer = CreateStreamConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateStreamResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateStreamResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateStreamDetails(), (BmcRequest)retriedRequest);
                return (CreateStreamResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateStreamPoolResponse createStreamPool(CreateStreamPoolRequest request) {
        LOG.trace("Called createStreamPool");
        CreateStreamPoolRequest interceptedRequest = CreateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "CreateStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/CreateStreamPool");
        Function<Response, CreateStreamPoolResponse> transformer = CreateStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateStreamPoolResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateStreamPoolResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateStreamPoolDetails(), (BmcRequest)retriedRequest);
                return (CreateStreamPoolResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteConnectHarnessResponse deleteConnectHarness(DeleteConnectHarnessRequest request) {
        LOG.trace("Called deleteConnectHarness");
        DeleteConnectHarnessRequest interceptedRequest = DeleteConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "DeleteConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/DeleteConnectHarness");
        Function<Response, DeleteConnectHarnessResponse> transformer = DeleteConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        return (DeleteConnectHarnessResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteConnectHarnessResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteConnectHarnessResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest request) {
        LOG.trace("Called deleteStream");
        DeleteStreamRequest interceptedRequest = DeleteStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "DeleteStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/DeleteStream");
        Function<Response, DeleteStreamResponse> transformer = DeleteStreamConverter.fromResponse(Optional.of(serviceDetails));
        return (DeleteStreamResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteStreamResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteStreamResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteStreamPoolResponse deleteStreamPool(DeleteStreamPoolRequest request) {
        LOG.trace("Called deleteStreamPool");
        DeleteStreamPoolRequest interceptedRequest = DeleteStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "DeleteStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/DeleteStreamPool");
        Function<Response, DeleteStreamPoolResponse> transformer = DeleteStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        return (DeleteStreamPoolResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteStreamPoolResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteStreamPoolResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetConnectHarnessResponse getConnectHarness(GetConnectHarnessRequest request) {
        LOG.trace("Called getConnectHarness");
        GetConnectHarnessRequest interceptedRequest = GetConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "GetConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/GetConnectHarness");
        Function<Response, GetConnectHarnessResponse> transformer = GetConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        return (GetConnectHarnessResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConnectHarnessResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConnectHarnessResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetStreamResponse getStream(GetStreamRequest request) {
        LOG.trace("Called getStream");
        GetStreamRequest interceptedRequest = GetStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "GetStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/GetStream");
        Function<Response, GetStreamResponse> transformer = GetStreamConverter.fromResponse(Optional.of(serviceDetails));
        return (GetStreamResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStreamResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStreamResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetStreamPoolResponse getStreamPool(GetStreamPoolRequest request) {
        LOG.trace("Called getStreamPool");
        GetStreamPoolRequest interceptedRequest = GetStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "GetStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool");
        Function<Response, GetStreamPoolResponse> transformer = GetStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        return (GetStreamPoolResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStreamPoolResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStreamPoolResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListConnectHarnessesResponse listConnectHarnesses(ListConnectHarnessesRequest request) {
        LOG.trace("Called listConnectHarnesses");
        ListConnectHarnessesRequest interceptedRequest = ListConnectHarnessesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectHarnessesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ListConnectHarnesses", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarnessSummary/ListConnectHarnesses");
        Function<Response, ListConnectHarnessesResponse> transformer = ListConnectHarnessesConverter.fromResponse(Optional.of(serviceDetails));
        return (ListConnectHarnessesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConnectHarnessesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConnectHarnessesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListStreamPoolsResponse listStreamPools(ListStreamPoolsRequest request) {
        LOG.trace("Called listStreamPools");
        ListStreamPoolsRequest interceptedRequest = ListStreamPoolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamPoolsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ListStreamPools", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPoolSummary/ListStreamPools");
        Function<Response, ListStreamPoolsResponse> transformer = ListStreamPoolsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListStreamPoolsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStreamPoolsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListStreamPoolsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest request) {
        LOG.trace("Called listStreams");
        ListStreamsRequest interceptedRequest = ListStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "ListStreams", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamSummary/ListStreams");
        Function<Response, ListStreamsResponse> transformer = ListStreamsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListStreamsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStreamsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListStreamsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateConnectHarnessResponse updateConnectHarness(UpdateConnectHarnessRequest request) {
        LOG.trace("Called updateConnectHarness");
        UpdateConnectHarnessRequest interceptedRequest = UpdateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "UpdateConnectHarness", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/ConnectHarness/UpdateConnectHarness");
        Function<Response, UpdateConnectHarnessResponse> transformer = UpdateConnectHarnessConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateConnectHarnessResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateConnectHarnessResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateConnectHarnessDetails(), (BmcRequest)retriedRequest);
                return (UpdateConnectHarnessResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateStreamResponse updateStream(UpdateStreamRequest request) {
        LOG.trace("Called updateStream");
        UpdateStreamRequest interceptedRequest = UpdateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "UpdateStream", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/Stream/UpdateStream");
        Function<Response, UpdateStreamResponse> transformer = UpdateStreamConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateStreamResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateStreamResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateStreamDetails(), (BmcRequest)retriedRequest);
                return (UpdateStreamResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateStreamPoolResponse updateStreamPool(UpdateStreamPoolRequest request) {
        LOG.trace("Called updateStreamPool");
        UpdateStreamPoolRequest interceptedRequest = UpdateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("StreamAdmin", "UpdateStreamPool", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/UpdateStreamPool");
        Function<Response, UpdateStreamPoolResponse> transformer = UpdateStreamPoolConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateStreamPoolResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateStreamPoolResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateStreamPoolDetails(), (BmcRequest)retriedRequest);
                return (UpdateStreamPoolResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public StreamAdminWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public StreamAdminPaginators getPaginators() {
        return this.paginators;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public StreamAdminClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new StreamAdminClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

