/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.streaming.StreamAdmin;
import com.oracle.bmc.streaming.model.ConnectHarness;
import com.oracle.bmc.streaming.model.Stream;
import com.oracle.bmc.streaming.model.StreamPool;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class StreamAdminWaiters {
    private final ExecutorService executorService;
    private final StreamAdmin client;

    public StreamAdminWaiters(ExecutorService executorService, StreamAdmin client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetConnectHarnessRequest, GetConnectHarnessResponse> forConnectHarness(GetConnectHarnessRequest request, ConnectHarness.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnectHarness(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConnectHarnessRequest, GetConnectHarnessResponse> forConnectHarness(GetConnectHarnessRequest request, ConnectHarness.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConnectHarness(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConnectHarnessRequest, GetConnectHarnessResponse> forConnectHarness(GetConnectHarnessRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ConnectHarness.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConnectHarness(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConnectHarnessRequest, GetConnectHarnessResponse> forConnectHarness(BmcGenericWaiter waiter, GetConnectHarnessRequest request, ConnectHarness.LifecycleState ... targetStates) {
        final HashSet<ConnectHarness.LifecycleState> targetStatesSet = new HashSet<ConnectHarness.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConnectHarnessRequest, GetConnectHarnessResponse>(){

            @Override
            public GetConnectHarnessResponse apply(GetConnectHarnessRequest request) {
                return StreamAdminWaiters.this.client.getConnectHarness(request);
            }
        }, (Predicate)new Predicate<GetConnectHarnessResponse>(){

            @Override
            public boolean test(GetConnectHarnessResponse response) {
                return targetStatesSet.contains((Object)response.getConnectHarness().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ConnectHarness.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetStreamRequest, GetStreamResponse> forStream(GetStreamRequest request, Stream.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStream(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStreamRequest, GetStreamResponse> forStream(GetStreamRequest request, Stream.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStream(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetStreamRequest, GetStreamResponse> forStream(GetStreamRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Stream.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStream(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetStreamRequest, GetStreamResponse> forStream(BmcGenericWaiter waiter, GetStreamRequest request, Stream.LifecycleState ... targetStates) {
        final HashSet<Stream.LifecycleState> targetStatesSet = new HashSet<Stream.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetStreamRequest, GetStreamResponse>(){

            @Override
            public GetStreamResponse apply(GetStreamRequest request) {
                return StreamAdminWaiters.this.client.getStream(request);
            }
        }, (Predicate)new Predicate<GetStreamResponse>(){

            @Override
            public boolean test(GetStreamResponse response) {
                return targetStatesSet.contains((Object)response.getStream().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Stream.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetStreamPoolRequest, GetStreamPoolResponse> forStreamPool(GetStreamPoolRequest request, StreamPool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStreamPool(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStreamPoolRequest, GetStreamPoolResponse> forStreamPool(GetStreamPoolRequest request, StreamPool.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStreamPool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetStreamPoolRequest, GetStreamPoolResponse> forStreamPool(GetStreamPoolRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, StreamPool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStreamPool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetStreamPoolRequest, GetStreamPoolResponse> forStreamPool(BmcGenericWaiter waiter, GetStreamPoolRequest request, StreamPool.LifecycleState ... targetStates) {
        final HashSet<StreamPool.LifecycleState> targetStatesSet = new HashSet<StreamPool.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetStreamPoolRequest, GetStreamPoolResponse>(){

            @Override
            public GetStreamPoolResponse apply(GetStreamPoolRequest request) {
                return StreamAdminWaiters.this.client.getStreamPool(request);
            }
        }, (Predicate)new Predicate<GetStreamPoolResponse>(){

            @Override
            public boolean test(GetStreamPoolResponse response) {
                return targetStatesSet.contains((Object)response.getStreamPool().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)StreamPool.LifecycleState.Deleted)), (Object)request);
    }
}

