/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.streaming.model.StreamSummary;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListStreamsConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(ListStreamsConverter.class);

    public static ListStreamsRequest interceptRequest(ListStreamsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListStreamsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180418").path("streams");
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        if (request.getStreamPoolId() != null) {
            target = target.queryParam("streamPoolId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStreamPoolId())});
        }
        if (request.getId() != null) {
            target = target.queryParam("id", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getId())});
        }
        if (request.getName() != null) {
            target = target.queryParam("name", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getName())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListStreamsResponse> fromResponse() {
        return ListStreamsConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, ListStreamsResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, ListStreamsResponse> transformer = new Function<Response, ListStreamsResponse>(){

            @Override
            public ListStreamsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcPrevPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.streaming.responses.ListStreamsResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<StreamSummary>>(){}, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<StreamSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListStreamsResponse.Builder builder = ListStreamsResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.items((List)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPrevPageHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-prev-page")).isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListStreamsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

